using System.Xml.Serialization;

namespace Implab.ServiceHost.Unity {
    public class MethodInjectionElement : AbstractMemberInjection {

        [XmlAttribute("name")]
        public string Name { get; set; }

        [XmlElement("dependency", typeof(DependencyParameterElement))]
        [XmlElement("value", typeof(ValueParameterElement))]
        [XmlElement("serialized", typeof(SerializedParameterElement))]
        [XmlElement("default", typeof(DefaultParameterElement))]
        [XmlElement("array", typeof(ArrayParameterElement))]
        public AbstractInjectionParameter[] Parameters { get; set; }

        public override void Visit(TypeRegistrationBuilder context) {
            context.Visit(this);
        }
    }
}