using System;
using System.Collections.Generic;
using System.Xml.Serialization;
using Unity.Lifetime;
using Unity.Registration;

namespace Implab.ServiceHost.Unity {

    [XmlRoot("register", Namespace = Schema.ContainerConfigurationNamespace)]
    public class RegisterElement : AbstractRegistration, ITypeRegistration  {
        
        /// <summary>
        /// An optional type which is registered as a service in the container, must be assignable to <see cref="ProvidesType">.
        /// </summary>
        [XmlAttribute("mapTo")]
        public string MapToType { get; set; }


        [XmlElement("constructor", typeof(ConstructorInjectionElement))]
        [XmlElement("property", typeof(PropertyInjectionElement))]
        [XmlElement("method", typeof(MethodInjectionElement))]
        public AbstractMemberInjection[] Injectors { get; set; }

        IEnumerable<ITypeMemberInjection> ITypeRegistration.MemberInjections {
            get {
                return Injectors;
            }
        }

        public Type GetImplementationType(ContainerBuilder builder) {
            return builder.ResolveType(MapToType);
        }

        public override void Visit(ContainerBuilder builder) {
            builder.Visit(this);
        }
    }
    
}