using System;
using System.Threading;

namespace Implab {
    public class SyncContextDispatcher : IDispatcher {
        SynchronizationContext m_context;
        public SyncContextDispatcher(SynchronizationContext context) {
            Safe.ArgumentNotNull(context, nameof(context));
            m_context = context;
        }

        public void Enqueue(Action job) {
            m_context.Post((o) => job(), null);
        }

        public void Enqueue<T>(Action<T> job, T arg) {
            m_context.Post((o) => job((T)o), arg);
        }
    }
}