using System;
using Jint.Runtime.VM.OpCodes;

namespace Jint.Runtime
{
    using VM;
    using System.IO;
    class MainClass
    {
        public static void Main(string[] args)
        {
			var runtime = new RuntimeContext ();

			var frame = new Frame (3,runtime);

			frame.Set (0, 0);
			frame.Set (1, 1);

			var op = new Add (0,1,0);

			var t = Environment.TickCount;

			for(int i=0; i < 10000000; i++)
				op.Invoke (frame);

			var res = frame.Get<int> (0);

			Console.WriteLine ("got: {0}, int {1} ms", res, Environment.TickCount - t );

			t = Environment.TickCount;

			object count = 0, inc = 1;
			for (int i=0; i< 10000000; i++)
				count = OpAdd(count,inc);

			Console.WriteLine ("reference results: {0}, int {1} ms", count, Environment.TickCount - t );
        }

		public static object OpAdd(object arg1, object arg2) {
			if (arg1.GetType () == arg2.GetType ()) {
				return OpAddIntegers(arg1,arg2);
			}
			throw new Exception ();
		}

		public static object OpAddIntegers(object arg1, object arg2) {
			return (int)arg1 + (int)arg2;
		}
    }
}
