﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Jint.Runtime.VM.OpCodes;

namespace Jint.Runtime.VM {
    class Box<T>: AbstractBox, IGettter<T>, ISetter<T> {

        public T holdingValue;
        object[] m_impl;
        RuntimeContext m_runtime;

        public Box(T value, RuntimeContext runtime): base(typeof(T)) {
            if (runtime == null)
                throw new ArgumentNullException("runtime");

            holdingValue = value;
            m_runtime = runtime;
        }

        object[] Impl {
            get {
                if (m_impl == null)
                    m_impl = m_runtime.GetImpl(typeof(T));
                return m_impl;
            }
        }

        public T Get() {
            return holdingValue;
        }

        public void Set(T value) {
            holdingValue = value;
        }

        public override void InvokeBinaryOperation(Codes code, int arg2, int dest, Frame frame) {
            var op = (BinaryOperation<T>)Impl[(int)code];
            frame.SetValue(dest, op(holdingValue, frame.GetValue<T>(arg2)));
        }

        public override void InvokeUnaryOperation(Codes code, int dest, Frame frame) {
            var op = (UnaryOperation<T>)Impl[(int)code];
            frame.SetValue(dest, op(holdingValue));
        }

        public override void InvokeCompareOperation(int arg2, int dest, Frame frame) {
            var op = (CompareOperation<T>)Impl[(int)Codes.Cmp];
            frame.SetValue(dest, op(holdingValue, frame.GetValue<T>(arg2)));
        }

        public override void InvokeEqualityOperation(int arg2, int dest, Frame frame) {
            var op = (EqualityOperation<T>)Impl[(int)Codes.Cmp];
            frame.SetValue(dest, op(holdingValue, frame.GetValue<T>(arg2)));
        }
    }
}
