using System;
using System.Collections.Generic;

namespace Jint.Runtime.VM2
{
	public class Machine
	{
		RuntimeContext m_context;
		//Stack<object[]> m_frames;
		Box[] m_frame;


		public Machine ()
		{
			m_context = new RuntimeContext ();
		}

		public void InitFrame(object[] values) {
			m_frame = new Box[values.Length];
			for(int i = 0; i< values.Length; i++)
				m_frame[i] = m_context.PackValue(values[i]);
		}

		public void Execute(Instruction[] instructions) {
			foreach (var op in instructions) {
				m_frame [op.dest].value = m_frame [op.args [0]].impl [(int)op.code](MakeArgs(op.args));
			}
		}

		private object[] MakeArgs(int[] regs) {
			object[] args = new object[regs.Length];
			for (int i=0; i< regs.Length; i++)
				args[i] = m_frame [regs [i]].value;
			return args;
		}

		public object Get(int index) {
			return m_frame [index];
		}
	}
}

