using System;

namespace Jint.Runtime.VM
{
	public class Frame
	{
		BoxBase[] m_data;
		RuntimeContext m_runtimeContext;

		public Frame (int size, RuntimeContext runtime)
		{
			if (size < 0)
				throw new ArgumentOutOfRangeException ("size");
			if (runtime == null)
				throw new ArgumentNullException ("runtime");

			m_data = new BoxBase[size];
			m_runtimeContext = runtime;
		}

		public RuntimeContext Runtime {
			get { return m_runtimeContext; }
		}

		public T Get<T> (int index)
		{
			var bbox = m_data [index];

			if (bbox == null)
				return default(T);

			var box = bbox as IGetter<T>;
			if (box != null)
				return box.Get();
			else
				return bbox.Convert<T>();
		}

		public void Set<T> (int index, T value)
		{
			var bbox = m_data [index];
			var box = bbox as ISetter<T>;
			if (box != null)
				box.Set (value);
			else
				m_data [index] = m_runtimeContext.BoxValue(value);
		}

		public BoxBase GetBox(int index) {
			return m_data[index];
		}

		public void SetBox(int index, BoxBase box) {
			m_data [index] = box;
		}

	}
}

