using System;
using Jint.Runtime.VM;

namespace Jint.Runtime
{
    using VM;
    using System.IO;
    using Jint.Runtime.VM.OpCodes;
    class MainClass
    {
        public static void Main(string[] args)
        {
            RuntimeContext runtime = new RuntimeContext();
            runtime.DefineBinaryOperation<int>(Codes.Add, (x, y) => x + y);
            runtime.DefineCompareOperation<int>((x, y) => x.CompareTo(y));

            var frame = new Frame(5,runtime);
            frame.SetValue(1, 10000000);
            frame.SetValue(2,0);
            frame.SetValue(3,1);


            var code = new LteCmp(2, 1, 4);
            var body = new BinaryOp(Codes.Add, 2, 3, 2);
            body.Chain(code);
            code.Chain(
                new ConditionOp(
                    4,
                    body,
                    null
                )
            );
                        

			var t = Environment.TickCount;

            /*
             *          mov r1, 10 000 000
             *          mov r2, 0
             *          mov r3, 1
             *          lte r2, r1, r4
             * cmp:
             *          test r4 { success => body, fail => end }
             * body:
             *          add r2,r3,r2
             *          goto cmp
             * end:
             */

            for (IInstruction op = code; op != null; op = op.Invoke(frame))
                ;

			Console.WriteLine ("vm: {0}, int {1} ms", frame.GetConverted<int>(2), Environment.TickCount - t );

            t = Environment.TickCount;

            object count = 0, inc = 1, max = 10000000;
            
            while(Compare(count,max) <= 0)
                count = Add(count,inc);

            Console.WriteLine("native: {0}, int {1} ms", frame.GetValue<int>(2), Environment.TickCount - t);

        }

        public static int Compare(object arg1, object arg2) {
            return ((int)arg1).CompareTo((int)arg2);
        }

        public static object Add(object arg1, object arg2) {
            return (int)arg1 + (int)arg2;
        }
    }
}
