﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Jint.Runtime.VM.OpCodes {
    class LteCmp: IInstruction {
        int m_arg1;
        int m_arg2;
        int m_dest;
        IInstruction m_next;

        public LteCmp(int arg1, int arg2, int dest) {
            m_arg1 = arg1;
            m_arg2 = arg2;
            m_dest = dest;
        }

        public IInstruction Chain(IInstruction next) {
            return m_next = next;
        }

        public IInstruction Invoke(Frame frame) {
            frame.SetValue(m_dest, frame[m_arg1].InvokeCompareOperation(m_arg2, frame) <= 0);
            return m_next;
        }
    }
}
