﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Jint.Runtime.VM.OpCodes {
    class ConditionOp: IInstruction {
        int m_test;
        IInstruction m_success;
        IInstruction m_fail;

        public ConditionOp(int test, IInstruction success, IInstruction fail) {
            m_test = test;
            m_success = success;
            m_fail = fail;
        }

        public IInstruction Invoke(Frame frame) {
            return frame.GetConverted<bool>(m_test) ? m_success : m_fail;
        }
    }
}
