using System;
using System.Collections.Generic;

namespace Jint.Runtime.VM
{
	class FunctionBuidler
	{
		Scope m_parentScope;

		/// <summary>
		/// maps local variable names to the registers
		/// </summary>
		Dictionary<string,int> m_locals;

		/// <summary>
		/// maps formal parameters to local variables
		/// </summary>
		int[] m_formalParameters;

		int m_frameSize;

		IInstruction m_code;

		RuntimeContext m_runtime;

		public FunctionBuilder (string[] argumentNames, RuntimeContext runtime, Scope parentScope)
		{
			m_parentScope;
			m_frameSize = 2; // reserve for this and scope

			m_locals = new Dictionary<string,int>();

			if (argumentNames!= null) {
				m_formalParameters = new int[argumentNames.Length];
				for(int i = 0; i < argumentNames.Length; i++)
					m_formalParameters[i] = AllocVariable(argumentNames[i]);
			}
		}

		// all vars should be allocated before temp registers
		public int AllocVariable(string name) {
			int id;

			if (m_locals.TryGetValue (name, out id))
				return id;

			id = m_frameSize++;
			m_locals [name] = id;
			return id;
		}

		public int AllocateRegister() {
			return m_frameSize++;
		}

		public void Invoke (object that, object[] args) {
			var frame = new Frame (m_frameSize, m_runtime);
			var scope = new Scope (m_locals, frame, m_declaringScope);
			frame.SetValue (Frame.ThisRegister, that);
			frame.SetValue (Frame.ScopeRegister, scope);

			var paramLen = Math.Min (m_formalParameters.Length, args.Length);

			for (int i=0; i< paramLen; i++)
				frame.SetValue (m_formalParameters [i], args [i]);
		}

	}
}

