﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Jint.Runtime.VM {
    class Frame {
        IBox[] m_registers;
        RuntimeContext m_runtime;

        public Frame(int size, RuntimeContext runtime) {
            if (runtime == null)
                throw new ArgumentNullException("runtime");
            if (size < 0)
                throw new ArgumentOutOfRangeException("size");
            m_runtime = runtime;
            m_registers = new IBox[size];
        }

        public IBox this[int index] {
            get {
                return m_registers[index];
            }
            set {
                m_registers[index] = value;
            }
        }

        public T GetValue<T>(int index) {
            // TODO handle conversion errors
            return ((Box<T>)m_registers[index]).holdingValue;
        }

        public void SetValue<T>(int index, T value) {
            var reg = m_registers[index] as Box<T>;
            if (reg == null)
                m_registers[index] = m_runtime.BoxValue(value);
            else
                reg.holdingValue = value;
        }
    }
}
