using System;
using Jint.Runtime.VM;

namespace Jint.Runtime
{
    using VM;
    using System.IO;
    using Jint.Runtime.VM.OpCodes;
    class MainClass
    {
        public static void Main(string[] args)
        {
            RuntimeContext runtime = new RuntimeContext();
            runtime.DefineBinaryOperation<int>(Codes.Add, (x, y) => x + y);

            var frame = new Frame(4,runtime);
            frame.SetValue(2,0);
            frame.SetValue(3,1);

            var op = new BinaryOp(Codes.Add, 2, 3, 2);

			var t = Environment.TickCount;

            /*
             *          mov r1, 10 000 000
             *          mov r2, 0
             *          mov r3, 1
             *          loop
             *              condition:
             *                  gte r2, r1
             *              body:
             *                  add r2,r3,r2
             */

            for (int i = 0; i < 10000000; i++)
                op.Invoke(frame);

			Console.WriteLine ("vm: {0}, int {1} ms", frame.GetValue<int>(2), Environment.TickCount - t );

            t = Environment.TickCount;

            /*
             *          mov r1, 10 000 000
             *          mov r2, 0
             *          mov r3, 1
             *          loop
             *              condition:
             *                  gte r2, r1
             *              body:
             *                  add r2,r3,r2
             */
            object count = 0, inc = 1;
            
            for (int i = 0; i < 10000000; i++)
                count = Add(count,inc);

            Console.WriteLine("native: {0}, int {1} ms", frame.GetValue<int>(2), Environment.TickCount - t);

			t = Environment.TickCount;
        }

        public static object Add(object arg1, object arg2) {
            return (int)arg1 + (int)arg2;
        }
    }
}
