﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Jint.Runtime.VM.OpCodes;

namespace Jint.Runtime.VM {
    class RuntimeContext {
        Dictionary<Type, object[]> m_impls;

        public RuntimeContext() {
            m_impls = new Dictionary<Type, object[]>();
        }

        public object[] GetImpl(Type type) {
            return m_impls[type];
        }

        public Box<T> BoxValue<T>(T value) {
            return new Box<T>(value, this);
        }

        public void DefineBinaryOperation<T>(Codes code, BinaryOperation<T> op) {
            object[] ops;
            if (!m_impls.TryGetValue(typeof(T), out ops))
                ops = m_impls[typeof(T)] = new object[(int)Codes.MaxOp];

            ops[(int)code] = op;
        }
    }
}
