﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Jint.Runtime.VM {
    using OpCodes;

    abstract class AbstractBox {

        protected AbstractBox(Type type) {
            holdingType = type;
        }

        public readonly Type holdingType;

        public abstract void InvokeBinaryOperation(Codes code, int arg2, int dest, Frame frame);
        public abstract void InvokeUnaryOperation(Codes code, int dest, Frame frame);
        public abstract int InvokeCompareOperation(int arg2, Frame frame);
        public abstract bool InvokeEqualityOperation(int arg2, Frame frame);
        public abstract T Convert<T>();
    }
}
