﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Jint.Runtime.VM.OpCodes {
    delegate void BinaryInstructionImpl(int arg1, int arg2, int dest, Frame frame);

    class BinaryOp: IInstruction {

        int m_dest;
        int m_arg1;
        int m_arg2;
        Codes m_code;
        IInstruction m_next;

        public BinaryOp(Codes code, int arg1, int arg2, int dest) {
            m_code = code;
            m_arg1 = arg1;
            m_arg2 = arg2;
            m_dest = dest;
        }

        public IInstruction Chain(IInstruction next) {
            m_next = next;
            return next;
        }

        public IInstruction Invoke(Frame frame) {
            //frame[m_arg1].GetBinaryImpl(m_code)(m_arg1, m_arg2, m_dest, frame);
            frame[m_arg1].InvokeBinaryOperation(m_code, m_arg2, m_dest, frame);

            return m_next;
        }
    }
}
