﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Jint.Runtime.VM.OpCodes;

namespace Jint.Runtime.VM {
    class RuntimeContext {
        Dictionary<Type, object[]> m_impls;

        public RuntimeContext() {
            m_impls = new Dictionary<Type, object[]>();
        }

        public object[] GetImpl(Type type) {
            return m_impls[type];
        }

        public Box<T> BoxValue<T>(T value) {
            return new Box<T>(value, this);
        }

        object[] GetOrCreateOps(Type type) {
            object[] ops;
            if (!m_impls.TryGetValue(type, out ops))
                ops = m_impls[type] = new object[(int)Codes.MaxOp];
            return ops;
        }

        public void DefineBinaryOperation<T>(Codes code, BinaryOperation<T> op) {
            object[] ops = GetOrCreateOps(typeof(T));
            ops[(int)code] = op;
        }

        public void DefineCompareOperation<T>(CompareOperation<T> op) {
            object[] ops = GetOrCreateOps(typeof(T));
            ops[(int)Codes.Cmp] = op;
        }
    }
}
