using System;
using System.Collections.Generic;

namespace Jint.Runtime.VM
{
	class Scope
	{
		Frame m_frame;
		Dictionary<string,int> m_vars;
		Scope m_parent;

		public const int ThisRegister = 0;
		public const int ScopeRegister = 1;
		public const int FirstVarRegsiter = 2;

		public Scope (IDictionary<string,int> vars, Frame frame, Scope parent)
		{
			if (vars == null)
				throw new ArgumentNullException ("vars");
			if (frame == null)
				throw new ArgumentNullException ("frame");

			m_vars = new Dictionary<string, int> (vars);
			m_frame = frame;
			m_parent = parent;
		}

		public IReference Resolve(string name) {
			if (String.IsNullOrEmpty (name))
				throw new ArgumentException ("The specified variable name is invalid");

			int index; 
			if (m_vars.TryGetValue (name, out index))
				return new ScopeReference (this, index);

			if (m_parent != null)
				return m_parent.Resolve (name);
			else
				throw new KeyNotFoundException (String.Format("The specified variable '{0}' isn't found",name));
		}
	}
}

