using System;

namespace Jint.Runtime.VM
{
	public class ScopeReference: IReference
	{
		Frame m_frame;
		int m_index;
		public ScopeReference (Frame frame, int index)
		{
			if (frame == null)
				throw new ArgumentNullException("frame");

			m_index = index;
			m_frame = frame;
		}


		#region IReference implementation
		public T Get<T> ()
		{
			return m_frame.GetValue<T>(m_index);
		}
		public void Put<T> (T value)
		{
			m_frame.SetValue(m_index);
		}
		public void CopyTo (Frame frame, int dest)
		{
			m_frame[m_index].CopyTo(frame,dest);
		}
		#endregion
	}
}

