using System;
using System.Collections.Generic;

namespace Jint.Runtime.VM
{
	public class RuntimeContext
	{
		Dictionary<Type,object> m_binders;

		public RuntimeContext ()
		{
			m_binders = new Dictionary<Type,object> ();
			m_binders.Add (typeof(int), new IntegerBinder ());
		}

		public Box<T> BoxValue<T>(T value) {
			return new Box<T> (value, GetBinder<T> ());
		}

		public IBinder<T> GetBinder<T>() {
			return (IBinder<T>) m_binders [typeof(T)];
		}
	}
}

