using System;

namespace Jint.Runtime.VM
{
	public class Box<T>: BoxBase, IGetter<T>, ISetter<T>
	{
		T m_value;
		IBinder<T> m_binder;

		public Box(T value,IBinder<T> binder) {
			m_value = value;
			m_binder = binder;
		}

		public override bool IsReference {
			get {
				return true;
			}
		}

        public override Type HoldingType
        {
            get { return typeof(T); }
        }

		#region IGetter implementation

		public T Get ()
		{
			return m_value;
		}

		#endregion

		#region ISetter implementation

		public void Set (T value)
		{
			m_value = value;
		}

		#endregion

		public override T2 Convert<T2> ()
		{
			if (m_binder == null)
				throw new ArgumentNullException ();
			return m_binder.Convert<T2> (m_value);
		}

		public override void Invoke(IBinaryOperation op, BoxBase arg2,Frame frame) {
			op.Invoke (m_value, ((IGetter<T>)arg2).Get (), m_binder, frame);
		}
	}
}

