using System;

namespace Jint.Runtime.VM
{
	public abstract class BinaryOperation: IBinaryOperation
	{
		protected int m_arg1;
		protected int m_arg2;
		protected int m_res;

		protected BinaryOperation(int arg1, int arg2, int res) {
			m_arg1 = arg1;
			m_arg2 = arg2;
			m_res = res;
		}

		public virtual void Fallback(BoxBase arg1, BoxBase arg2, Frame frame) {
			throw new InvalidOperationException ("Unable to perform a binary operation on the specified arguments");
		}

		#region IBinaryOperation implementation

		public abstract void Invoke<T> (T arg1, T arg2, IBinder<T> binder, Frame frame);

		#endregion

		#region IOperation implementation

		public void Invoke (Frame frame)
		{
			var box1 = frame.GetBox (m_arg1);
			var box2 = frame.GetBox (m_arg2);

			if (box1 != null && box2 != null && box1.HoldingType == box2.HoldingType) {
				box1.Invoke (this, box2, frame);
			} else {
				Fallback (box1, box2, frame);
			}
		}

		#endregion
	}
}

