<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<xsl:output method="text" />

	<xsl:template match="*[count(*) = 0]">
		<xsl:apply-templates mode="json-value" />
	</xsl:template>

	<xsl:template match="*[count(*) > 0]">
		<xsl:text>{ </xsl:text>
		<xsl:apply-templates mode="json-object-member"/>
		<xsl:text> }</xsl:text>
	</xsl:template>
	
	<xsl:template match="text()"/>

	<!-- handle json-object -->
	
	<xsl:template name="write-object">
	
	</xsl:template>

	<xsl:template match="*" mode="json-object-member">
		<xsl:call-template name="write-json-string">
			<xsl:with-param name="text" select="local-name(.)"/>
		</xsl:call-template>
		<xsl:text> : </xsl:text>
		<xsl:apply-templates mode="json-value"/>
		<xsl:if test="position() != last()">
			<xsl:text>, </xsl:text>
		</xsl:if>
	</xsl:template>
	
	<!-- handle json-value -->

	<xsl:template match="*[@xsi:nil = 'true']">
		<xsl:text>null</xsl:text>
	</xsl:template>

	<xsl:template match="text()[. = 'true']" mode="json-value">
		<xsl:text>true</xsl:text>
	</xsl:template>

	<xsl:template match="text()[. = 'false']"
		mode="json-value">
		<xsl:text>false</xsl:text>
	</xsl:template>

	<xsl:template match="text()[string(number(.)) != 'NaN']"
		mode="json-value">
		<xsl:value-of select="number(.)" />
	</xsl:template>

	<xsl:template match="text()" mode="json-value">
		<xsl:call-template name="write-json-string">
			<xsl:with-param name="text" select="."/>
		</xsl:call-template>
	</xsl:template>

	<xsl:template match="*" mode="json-value">
		<xsl:apply-templates select="."/>
	</xsl:template>
	
	<!-- template traits -->
	<xsl:template name="write-json-string">
		<xsl:param name="text"/>
		<xsl:value-of select="concat('&quot;', $text,'&quot;')" />
	</xsl:template>

</xsl:stylesheet>