<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:exsl="http://exslt.org/common">
	<xsl:import href="json.xsl"/>
	<xsl:output method="text" />
	
	<xsl:template match="firstName | lastName" mode="json-member-value">
		<xsl:call-template name="write-value">
			<xsl:with-param name="value" select="key('members',concat(generate-id(..),local-name(.)))[last()]"/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template match="address" mode="json-member-value">
		<xsl:call-template name="write-array"/>
	</xsl:template>
	
	<xsl:template match="work | home">
		<address>
			<_type><xsl:value-of select="local-name(.)"/></_type>
			<xsl:copy-of select="*"/>
		</address>
	</xsl:template>
	
	<xsl:template match="@*">
		<xsl:element name="{local-name(.)}" >
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	
</xsl:stylesheet>