<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text"/>
	
	<xsl:template match="/">
		<xsl:apply-templates mode="json-array" />
	</xsl:template>
	
	<xsl:template match="*" mode="json-array">
		[
			<xsl:for-each select="*">
				<xsl:apply-templates select="." mode="json-value"/>
				<xsl:if test="position() != last()">,</xsl:if>
			</xsl:for-each>
		]
	</xsl:template>
	
	<xsl:template match="*[count(*) != 0]" mode="json-array-item">
		"<xsl:value-of select="name()"/> : <xsl:apply-templates mode="json-value"/>"
		<xsl:if test="position() != last()">,</xsl:if>
	</xsl:template>
	
	<xsl:template match="*" mode="json-value">
		<xsl:choose>
			<xsl:when test="count(*) != 0">{ <xsl:apply-templates mode="json-named-value" /> }</xsl:when>
			<xsl:when test="text() = 'true'">true</xsl:when>
			<xsl:when test="text() = 'false'">false</xsl:when>
			<xsl:when test="text() = 'null'">null</xsl:when>
			<xsl:when test="string(number(.)) != 'NaN'"><xsl:value-of select="number(.)"/></xsl:when>
			<xsl:otherwise>"<xsl:value-of select="text()"/>"</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="*" mode="json-named-value">
		<xsl:value-of select="name()"/> : <xsl:apply-templates select="." mode="json-value"/>
	</xsl:template>	
</xsl:stylesheet>