<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:m="http://implab.org/schemas/data-model.v1.xsd"
	xmlns:exsl="http://exslt.org/common"
	xmlns:t="http://implab.org/schemas/temp"
>
	<!--
	This template provides 'module' variable which is the
	result of processing imports from packages.
	
	Variable $module is a node set created from the result-tree
	which is the result of applying templates in mode=preprocess  
	-->
	<xsl:output method="xml" indent="yes" />
	<xsl:variable name="preprocessResult">
		<t:module>
			<xsl:call-template name="preprocess" />
		</t:module>
	</xsl:variable>
	<xsl:variable name="module" select="exsl:node-set($preprocessResult)/t:module"/>

	<xsl:template name="preprocess">
		<xsl:param name="root" select="/" />
		<xsl:param name="pending" select="$root/m:package/m:import[@href]" />
		<xsl:param name="seen" select="/.." />
		<xsl:param name="file" select="''" />
		<xsl:param name="primary" select="true()" />

		<xsl:if test="not($seen[generate-id() = generate-id($root)])">
			<xsl:apply-templates select="$root" mode="preprocess">
				<xsl:with-param name="primary" select="$primary" />
				<xsl:with-param name="file" select="$file" />
			</xsl:apply-templates>
			<xsl:if test="$pending">
				<xsl:variable name="doc" select="document($pending[1]/@href)" />
				<xsl:call-template name="preprocess">
					<xsl:with-param name="root" select="$doc" />
					<xsl:with-param name="file" select="$pending[1]/@href" />
					<xsl:with-param name="pending"
						select="$pending[position() > 1] | $doc/m:package/m:import[@href]" />
					<xsl:with-param name="seen" select="$root | $seen" />
					<xsl:with-param name="primary" select="false()" />
				</xsl:call-template>
			</xsl:if>
		</xsl:if>
	</xsl:template>

	<xsl:template match="m:package" mode="preprocess">
		<xsl:param name="primary" />
		<xsl:param name="file" />
		<xsl:copy>
			<xsl:copy-of select="@*" />
			<xsl:if test="$primary">
				<xsl:attribute name="primary"><xsl:value-of select="$primary" /></xsl:attribute>
			</xsl:if>
			<xsl:if test="$file">
				<xsl:attribute name="file"><xsl:value-of select="$file" /></xsl:attribute>
			</xsl:if>
			<xsl:apply-templates mode="preprocess">
				<xsl:with-param name="primary" select="$primary" />
				<xsl:with-param name="file" select="$file" />
			</xsl:apply-templates>
		</xsl:copy>
	</xsl:template>

	<xsl:template match="*|/" mode="preprocess">
		<xsl:param name="primary" />
		<xsl:param name="file" />
		<xsl:copy>
			<xsl:copy-of select="@*" />
			<xsl:apply-templates mode="preprocess">
				<xsl:with-param name="primary" select="$primary" />
				<xsl:with-param name="file" select="$file" />
			</xsl:apply-templates>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>