<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:m="http://implab.org/schemas/data-model.v1.xsd"
	xmlns:clr="http://implab.org/schemas/data-model/dotnet.v1.xsd"
	xmlns:cs="http://implab.org/schemas/code-dom/csharp.v1.xsd" xmlns:sql="http://implab.org/schemas/data-model/sql.v1.xsd"
	xmlns:t="http://implab.org/schemas/temp" xmlns:exsl="http://exslt.org/common"
	exclude-result-prefixes="clr m xsl exsl sql">
	<xsl:import href="model.xsl"/>
	
	<xsl:output method="xml" indent="yes" />
	
	<!-- generate code for primary package -->
	<xsl:template match="m:package[@primary='true' and @clr:namespace]"	mode="document">
		<cs:namespace name="{@clr:namespace}">
			<xsl:apply-templates mode="document" />
		</cs:namespace>
	</xsl:template>

	<xsl:template match="m:package[@primary='true']" mode="document">
		<xsl:apply-templates mode="document" />
	</xsl:template>
	
	<!-- entity -->
	<xsl:template match="m:entity" mode="document">
		<xsl:apply-templates select="." mode="entity"/>
	</xsl:template>
	
	<xsl:template match="m:entity" mode="entity">
		<!-- select all members -->
		<xsl:variable name="members">
			<xsl:apply-templates mode="fiter-members"/>
		</xsl:variable>
		
		<cs:class modifiers="partial">
			<!-- generate class name -->
			<xsl:attribute name="name">
				<xsl:apply-templates select="." mode="class-name"/>
			</xsl:attribute>
			<xsl:attribute name="modifiers">
				<xsl:apply-templates select="." mode="class-modifiers"/>
			</xsl:attribute>
			
			<xsl:apply-templates mode="class-attributes" />
			<xsl:apply-templates select="exsl:node-set($members)" mode="members" />
		</cs:class>
	</xsl:template>
	
	<!-- class-name -->
	<xsl:template match="*[@name]" mode="class-name">
		<xsl:value-of select="@name"/>
	</xsl:template>
	
	<xsl:template match="*[@clr:name]" mode="class-name">
		<xsl:value-of select="@clr:name"/>
	</xsl:template>
	
	<!-- class-modifiers -->
	<xsl:template match="*" mode="class-modifiers">
		<xsl:text>partial</xsl:text>
	</xsl:template>
	
	<!-- class-attributes -->
	<xsl:template match="*|text()" mode="class-attributes" />

	<xsl:template match="sql:table" mode="class-attributes">
		<cs:attribute>
			<cs:type name="Table" namespace="Linq2Db" />
			<cs:parameter><cs:string text="{@name}"/></cs:parameter>
		</cs:attribute>
	</xsl:template>
	
	<!-- generate members -->

	<xsl:template match="*|text()" mode="members" />

	<xsl:template match="m:primaryKey | m:property | m:thisKey | clr:association" mode="members">
		<t:trace msg="{name()} {@name}"/>
		<xsl:apply-templates select="." mode="property"/>
	</xsl:template>
	
	<!-- hasA and hasMany doesn't generate members itself, they delegate this work to inner members -->
	<xsl:template match="m:hasA | m:hasMany" mode="members">
		<t:trace msg="{name()} {@name}" />
		<xsl:apply-templates mode="members" />
	</xsl:template>
	
	<xsl:template match="m:hasA/clr:lazy" mode="members">
		<xsl:apply-templates select="." mode="field"/>
	</xsl:template>

	<!-- member-name -->
	<xsl:template match="*|text()|@*" mode="member-name" />

	<xsl:template match="*[@name]" mode="member-name">
		<xsl:value-of select="@name"/>
	</xsl:template>
	<xsl:template match="*[@clr:name]" mode="member-name">
		<xsl:value-of select="@clr:name"/>
	</xsl:template>
	
	<!-- member-type -->
	<xsl:template match="*|text()|@*" mode="member-type" />
	
	<xsl:template match="*[@type]" mode="member-type">
		<xsl:call-template name="getClrType">
			<xsl:with-param name="type" select="@type" />
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template match="*[clr:type]" mode="member-type">
		<xsl:apply-templates select="clr:type" mode="clr-type" />
	</xsl:template>
	
	<!-- member-attributes -->
	<xsl:template match="*|text()" mode="member-attributes"/>
	
	<!-- member-extension -->
	<xsl:template match="*|text()" mode="member-extension"/>
	<xsl:template match="*" mode="member-extension">
		<xsl:apply-templates mode="member-extension-comments"/>
	</xsl:template>
	
	<xsl:template match="m:hasA/* | m:hasMany/*" mode="member-extension">
		<xsl:variable name="comments" select="../m:description | m:description"/>
		<xsl:apply-templates select="$comments[position() = count($comments)]" mode="member-extension-comments"/>
	</xsl:template>
	
	<!-- member-extension-comments -->
	<xsl:template match="*|text()" mode="member-extension-comments"/>
	
	<xsl:template match="m:description" mode="member-extension-comments">
		<cs:comments>
			<xsl:apply-templates mode="comments" />
		</cs:comments>
	</xsl:template>
		
	<!-- property -->
	
	<xsl:template match="*" mode="property">
		<cs:property modifiers="public">
			<xsl:attribute name="name"><xsl:apply-templates select="." mode="property-name"/></xsl:attribute>
			<xsl:attribute name="modifiers"><xsl:apply-templates select="." mode="property-modifiers"/></xsl:attribute>
			<xsl:apply-templates select="." mode="property-type"/>
			<xsl:apply-templates select="." mode="property-attributes"/>
			<xsl:apply-templates select="." mode="property-extension" />
			<xsl:apply-templates select="." mode="property-accessors"/>
		</cs:property>
	</xsl:template>
	
	
	<!-- property-name -->
	<xsl:template match="m:hasA/clr:association[not(@name|@clr:name)]" mode="property-name">
		<!-- if the association doesn't define a name, use it from the parent node -->
		<xsl:apply-templates select=".." mode="property-name"/>
	</xsl:template>
	<xsl:template match="m:hasMany/clr:association[not(@name|@clr:name)]" mode="property-name">
		<!-- if the association doesn't define a name, use it from the parent node -->
		<xsl:apply-templates select=".." mode="property-name"/>
	</xsl:template>
	
	<xsl:template match="*" mode="property-name">
		<xsl:apply-templates select="." mode="member-name"/>
	</xsl:template>
	
	<!-- property-modifiers -->
	<xsl:template match="*" mode="property-modifiers">
		<xsl:text>public</xsl:text>
	</xsl:template>
	
	<!-- property-type -->
	<xsl:template match="*" mode="property-type">
		<xsl:apply-templates select="." mode="member-type"/>
	</xsl:template>
	
	<xsl:template match="m:hasA[@type]/clr:association[not(clr:type)]" mode="property-type">
		<xsl:apply-templates select=".." mode="property-type"/>
	</xsl:template>
	
	<xsl:template match="m:hasMany[@type]/clr:association[not(clr:type)]" mode="property-type">
		<cs:array>
			<xsl:apply-templates select=".." mode="property-type"/>
		</cs:array>
	</xsl:template>
	
	<xsl:template match="m:hasA[@type]/m:thisKey" mode="property-type">
		<xsl:variable name="otherKey">
			<xsl:call-template name="getPrimaryKey">
				<xsl:with-param name="type" select="../@type"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="@optional">
			</xsl:when>
				<cs:nullable>
					<xsl:apply-templates select="exsl:node-set($otherKey)" mode="property-type"/>
				</cs:nullable>
			<xsl:otherwise>
				<xsl:apply-templates select="exsl:node-set($otherKey)" mode="property-type"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- property-attributes -->
	<xsl:template match="m:primaryKey" mode="property-attributes">
		<cs:attribute>
			<cs:type name="PrimaryKey" namespace="Linq2Db" />
		</cs:attribute>
	</xsl:template>
	
	<xsl:template match="m:hasA/clr:association" mode="property-attributes">
		<cs:attribute>
			<cs:type name="Association" namespace="Linq2Db"/>
			<cs:parameter name="thisKey">
				<cs:nameOf>
					<xsl:call-template name="getMember">
						<xsl:with-param name="memberName" select="../@name"/>
						<xsl:with-param name="explicitMemberName" select="@thisKey"/>
						<xsl:with-param name="type" select="../../@name"/>
						<xsl:with-param name="short" select="true()"/>
					</xsl:call-template>
				</cs:nameOf>
			</cs:parameter>
			<cs:parameter name="otherKey">
				<cs:nameOf>
					<xsl:call-template name="getKeyMember">
						<xsl:with-param name="explicitMemberName" select="@thisKey"/>
						<xsl:with-param name="type" select="../@type"/>
					</xsl:call-template>
				</cs:nameOf>
			</cs:parameter>
		</cs:attribute>
	</xsl:template>

	<xsl:template match="m:hasMany/clr:association" mode="property-attributes">
		<cs:attribute>
			<cs:type name="Association" namespace="Linq2Db"/>
			<!-- thisKey points to own primaryKey which may be inherited, using getKeyName to address such cases -->
			<cs:parameter name="thisKey">
				<cs:nameOf>
					<xsl:call-template name="getKeyMember">
						<xsl:with-param name="type" select="../../@name"/>
						<xsl:with-param name="explicitMemberName" select="@thisKey"/>
						<xsl:with-param name="short" select="true()"/>
					</xsl:call-template>
				</cs:nameOf>
			</cs:parameter>
			<cs:parameter name="otherKey">
				<cs:nameOf>	
					<xsl:call-template name="getMember">
						<xsl:with-param name="type" select="../@type"/>
						<xsl:with-param name="memberName" select="../m:otherKey/@name"/>
						<xsl:with-param name="explicitMemberName" select="@otherKey"/>
					</xsl:call-template>
				</cs:nameOf>
			</cs:parameter>
		</cs:attribute>
	</xsl:template>
	
	<xsl:template match="*" mode="property-attributes">
		<xsl:apply-templates select="." mode="member-attributes"/>
	</xsl:template>	
	
	<!-- property-extension -->
	<xsl:template match="*" mode="property-extension">
		<xsl:apply-templates select="." mode="member-extension"/>
	</xsl:template>
	
	<!-- property-accessors -->
	<xsl:template match="*" mode="property-accessors">
		<cs:get/>
		<cs:set/>
	</xsl:template>
	
	<xsl:template match="m:hasA[clr:lazy]/m:thisKey" mode="property-accessors">
		<cs:get>
			<xsl:text>return </xsl:text>
			<xsl:apply-templates select="../clr:lazy" mode="field-name"/>
			<xsl:text>.Key;</xsl:text>
		</cs:get>
		<cs:set>
			<xsl:apply-templates select="../clr:lazy" mode="field-name"/>
			<xsl:text>.Key = value;</xsl:text>
		</cs:set>
	</xsl:template>
	
	<xsl:template match="m:hasA[clr:lazy]/clr:association" mode="property-accessors">
		<cs:get>
			<xsl:text>return </xsl:text>
			<xsl:apply-templates select="../clr:lazy" mode="field-name"/>
			<xsl:text>.Instance;</xsl:text>
		</cs:get>
		<cs:set>
			<xsl:apply-templates select="../clr:lazy" mode="field-name"/>
			<xsl:text>.Instance = value;</xsl:text>
		</cs:set>
	</xsl:template>
	
	<!-- fields -->
	<xsl:template match="*" mode="field">
		<cs:field>
			<xsl:attribute name="name"><xsl:apply-templates select="." mode="field-name"/></xsl:attribute>
			<xsl:apply-templates select="." mode="field-type"/>
			<xsl:apply-templates select="." mode="field-initializer"/>
		</cs:field>
	</xsl:template>
	
	<!-- field-name  -->
	<xsl:template match="m:hasA/clr:lazy" mode="field-name">
		<xsl:text>m_lazy</xsl:text>
		<xsl:apply-templates select=".." mode="property-name"/>
	</xsl:template>
	
	<xsl:template match="clr:lazy[@field]" mode="field-name">
		<xsl:value-of select="@field"/>
	</xsl:template>
	
	<xsl:template match="*" mode="field-name">
		<xsl:apply-templates select="." mode="member-name"/>
	</xsl:template>
	
	<!-- field-type -->
	<xsl:template match="m:hasA[@optional='true']/clr:lazy" mode="field-type">
		<cs:type name="NullableReference" namespace="Pallada.Data">
			<xsl:call-template name="getKeyType">
				<xsl:with-param name="type" select="../@type"/>
			</xsl:call-template>
			<xsl:apply-templates select=".." mode="property-type"/>
		</cs:type>
	</xsl:template>
	<xsl:template match="m:hasA[@optional!='true']/clr:lazy" mode="field-type">
		<cs:type name="Reference" namespace="Pallada.Data">
			<xsl:apply-templates select="../m:thisKey" mode="property-type"/>
			<xsl:apply-templates select=".." mode="property-type"/>
		</cs:type>
	</xsl:template>
	
	<xsl:template match="*" mode="field-type">
		<xsl:apply-templates select="." mode="member-type"/>
	</xsl:template>
	<!-- field-initializer -->
	<xsl:template match="*|text()" mode="field-initializer"/>
	
	<xsl:template name="getClrKeyReference">
		<xsl:param name="type"/>
		<xsl:variable name="primaryKey">
			<xsl:call-template name="getPrimaryKey">
				<xsl:with-param name="type" select="$type"/>
			</xsl:call-template>
		</xsl:variable>
		
		<xsl:apply-templates select="exsl:node-set($primaryKey)" mode="clr-member-reference"/>
	</xsl:template>
	
	<!-- -->
	<xsl:template name="getClrMemberReference">
		<xsl:param name="type"/>
		<xsl:param name="memberName"/>
		<xsl:param name="scope" select="members"/>
		<xsl:variable name="member">
			<xsl:call-template name="getMembers">
				<xsl:with-param name="memberName" select="$memberName"/>
				<xsl:with-param name="type" select="$type"/>
			</xsl:call-template>
		</xsl:variable>
		
		<xsl:apply-templates select="exsl:node-set($member)" mode="clr-member-reference"/>
	</xsl:template>
	
	<xsl:template match="*" mode="clr-member-reference">
		<xsl:param name="$type" select="@declaringType"/>
		<cs:member>
			<xsl:attribute name="name">
				<xsl:apply-templates select="." mode="member-name"/>
			</xsl:attribute>
			<xsl:call-template name="getClrType">
				<xsl:with-param name="type" select="$type"/>
			</xsl:call-template>
		</cs:member>
	</xsl:template>
	
	
	<!-- resolves CLR type for the given type -->
	<xsl:template name="getClrType">
		<xsl:param name="type" />
		<xsl:param name="typeArgs" select="/.." />
		<!-- <t:trace msg="resolveClrType {$type}"/> -->
		<xsl:for-each select="$module">
			<xsl:apply-templates select="key('type', $type)"
				mode="clr-type">
				<xsl:with-param name="typeArgs" select="$typeArgs"/>
			</xsl:apply-templates>
		</xsl:for-each>
	</xsl:template>
	
	<!-- CLR type construction -->
	<xsl:template match="*" mode="clr-type" />

	<xsl:template match="m:type[clr:type]" mode="clr-type">
		<xsl:param name="typeArgs" select="clr:type/*" />
		<xsl:apply-templates select="clr:type" mode="clr-type">
			<xsl:with-param name="typeArgs" select="$typeArgs" />
		</xsl:apply-templates>
	</xsl:template>

	<xsl:template match="m:entity" mode="clr-type">
		<cs:type name="{@clr:name | @name[not(../@clr:name)]}" namespace="{ancestor::*[@clr:namespace]/@clr:namespace}" />
	</xsl:template>
	
	<xsl:template match="clr:type" mode="clr-type">
		<xsl:apply-templates mode="clr-type"/>
	</xsl:template>

	<xsl:template match="clr:type[@ref]" mode="clr-type">
		<xsl:param name="typeArgs" select="*" />
		<xsl:call-template name="getClrType">
			<xsl:with-param name="type" select="@ref" />
			<xsl:with-param name="typeArgs" select="$typeArgs" />
		</xsl:call-template>
	</xsl:template>

	<xsl:template match="clr:type[@cs:name or @name]" mode="clr-type">
		<xsl:param name="typeArgs" select="*" />
		<xsl:variable name="ns"
			select="@cs:namespace | @namespace[not(../@cs:namespace)]" />
		<cs:type name="{@cs:name | @name[not(../@cs:name)]}">
			<xsl:if test="$ns">
				<xsl:attribute name="namespace"><xsl:value-of select="$ns" /></xsl:attribute>
			</xsl:if>
			<xsl:copy-of select="@struct"/>
			
			<xsl:apply-templates select="$typeArgs | *[not($typeArgs)]"
				mode="clr-type" />
		</cs:type>
	</xsl:template>

	<xsl:template match="clr:arrayOf[@type]" mode="clr-type">
		<xsl:param name="typeArgs" select="*" />
		<cs:array>
			<xsl:call-template name="getClrType">
				<xsl:with-param name="type" select="@type" />
				<xsl:with-param name="typeArgs" select="$typeArgs" />
			</xsl:call-template>
		</cs:array>
	</xsl:template>

	<xsl:template match="clr:arrayOf[@cs:name or @name]" mode="clr-type">
		<xsl:param name="typeArgs" select="*" />
		<xsl:variable name="ns"
			select="@cs:namespace | @namespace[not(../@cs:namespace)]" />
		<cs:array>
			<cs:type name="{@cs:name | @name[not(../@cs:name)]}">
				<xsl:if test="$ns">
					<xsl:attribute name="namespace"><xsl:value-of
						select="$ns" /></xsl:attribute>
				</xsl:if>
				<xsl:apply-templates select="$typeArgs | *[not($typeArgs)]"
					mode="clr-type" />
			</cs:type>
		</cs:array>
	</xsl:template>
	
	
</xsl:stylesheet>