<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:cs="http://implab.org/schemas/code-dom/csharp.v1.xsd">
	<xsl:import href="text-tools.xsl" />

	<!-- CODE GENERATION -->

	<!-- GENERATE NAMESPACE -->
	<xsl:template match="cs:namespace">
		<xsl:param name="level" select="0" />
		<xsl:call-template name="write-line">
			<xsl:with-param name="level" select="$level" />
			<xsl:with-param name="text">
				<xsl:text>namespace </xsl:text>
				<xsl:value-of select="@name" />
				<xsl:text> {</xsl:text>
			</xsl:with-param>
		</xsl:call-template>
		<xsl:apply-templates>
			<xsl:with-param name="level" select="$level+1" />
		</xsl:apply-templates>
		<xsl:call-template name="write-line">
			<xsl:with-param name="level" select="$level" />
			<xsl:with-param name="text">
				}
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

	<!-- GENERATE CLASS -->
	<xsl:template match="cs:class">
		<xsl:param name="level" select="0" />
		<xsl:call-template name="write-line">
			<xsl:with-param name="level" select="$level" />
			<xsl:with-param name="text">
				<xsl:text>class </xsl:text>
				<xsl:value-of select="@name" />
				<xsl:text> {</xsl:text>
			</xsl:with-param>
		</xsl:call-template>

		<xsl:apply-templates mode="members">
			<xsl:with-param name="level" select="$level+1" />
			<xsl:with-param name="declaringType" select="." />
		</xsl:apply-templates>

		<xsl:call-template name="write-line">
			<xsl:with-param name="level" select="$level" />
			<xsl:with-param name="text" select="'}'" />
		</xsl:call-template>
	</xsl:template>

	<!-- GENERATE FIELDS -->
	<xsl:template match="cs:field" mode="members">
		<xsl:param name="level" select="0" />
		<xsl:call-template name="write-line">
			<xsl:with-param name="level" select="$level" />
			<xsl:with-param name="text">
				<xsl:value-of select="concat(@type,' ', @name)" />
				<xsl:if test="@initializer">
					<xsl:text> = </xsl:text>
					<xsl:value-of select="@initializer" />
				</xsl:if>
				<xsl:text>;</xsl:text>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

	<!-- GENERATE PROPERTIES -->
	<xsl:template match="cs:property" mode="members">
		<xsl:param name="level" select="0" />
		<xsl:call-template name="write-line">
			<xsl:with-param name="level" select="$level" />
			<xsl:with-param name="text" select="concat(@type,' ', @name, ' {')" />
		</xsl:call-template>
		<xsl:apply-templates>
			<xsl:with-param name="level" select="$level + 1" />
		</xsl:apply-templates>
		<xsl:call-template name="write-line">
			<xsl:with-param name="level" select="$level" />
			<xsl:with-param name="text" select="'}'" />
		</xsl:call-template>
	</xsl:template>
</xsl:stylesheet>