﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:m="http://implab.org/schemas/data-model.v1.xsd"
	xmlns:clr="http://implab.org/schemas/data-model/dotnet.v1.xsd"
	xmlns:cs="http://implab.org/schemas/code-dom/csharp.v1.xsd" xmlns:sql="http://implab.org/schemas/data-model/sql.v1.xsd"
	xmlns:t="http://implab.org/schemas/temp" xmlns:exsl="http://exslt.org/common"
	exclude-result-prefixes="clr m xsl exsl sql">
	<xsl:output method="xml" indent="yes" />

	<xsl:key name="type" match="m:package/m:*" use="@name" />

	<xsl:variable name="fragment">
		<t:fragment>
			<xsl:call-template name="preprocess" />
		</t:fragment>
	</xsl:variable>

	<xsl:template name="preprocess">
		<xsl:param name="root" select="/" />
		<xsl:param name="pending" select="$root/m:package/m:import[@href]" />
		<xsl:param name="seen" select="/.." />
		<xsl:param name="file" select="''" />
		<xsl:param name="primary" select="true()" />

		<xsl:if test="not($seen[generate-id() = generate-id($root)])">
			<xsl:apply-templates select="$root" mode="preprocess">
				<xsl:with-param name="primary" select="$primary" />
				<xsl:with-param name="file" select="$file" />
			</xsl:apply-templates>
			<xsl:if test="$pending">
				<xsl:variable name="doc" select="document($pending[1]/@href)" />
				<xsl:call-template name="preprocess">
					<xsl:with-param name="root" select="$doc" />
					<xsl:with-param name="file" select="$pending[1]/@href" />
					<xsl:with-param name="pending"
						select="$pending[position() > 1] | $doc/m:package/m:import[@href]" />
					<xsl:with-param name="seen" select="$root | $seen" />
					<xsl:with-param name="primary" select="false()" />
				</xsl:call-template>
			</xsl:if>
		</xsl:if>
	</xsl:template>

	<xsl:template match="m:package" mode="preprocess">
		<xsl:param name="primary" />
		<xsl:param name="file" />
		<xsl:copy>
			<xsl:copy-of select="@*" />
			<xsl:if test="$primary">
				<xsl:attribute name="primary"><xsl:value-of select="$primary" /></xsl:attribute>
			</xsl:if>
			<xsl:if test="$file">
				<xsl:attribute name="file"><xsl:value-of select="$file" /></xsl:attribute>
			</xsl:if>
			<xsl:apply-templates mode="preprocess">
				<xsl:with-param name="primary" select="$primary" />
				<xsl:with-param name="file" select="$file" />
			</xsl:apply-templates>
		</xsl:copy>
	</xsl:template>

	<xsl:template match="*|/" mode="preprocess">
		<xsl:param name="primary" />
		<xsl:param name="file" />
		<xsl:copy>
			<xsl:copy-of select="@*" />
			<xsl:apply-templates mode="preprocess">
				<xsl:with-param name="primary" select="$primary" />
				<xsl:with-param name="file" select="$file" />
			</xsl:apply-templates>
		</xsl:copy>
	</xsl:template>

	<xsl:template match="/">
		<cs:document>
			<xsl:apply-templates select="exsl:node-set($fragment)"
				mode="generate-document" />
		</cs:document>
	</xsl:template>

	<!-- code generation -->

	<!-- disable default template -->
	<xsl:template match="*|text()" mode="generate-document" />

	<xsl:template match="t:fragment" mode="generate-document">
		<xsl:apply-templates mode="generate-document" />
	</xsl:template>

	<!-- generate code for primary package -->
	<xsl:template match="m:package[@primary='true' and @clr:namespace]"
		mode="generate-document" priority="1">
		<cs:namespace name="{@clr:namespace}">
			<xsl:apply-templates mode="generate-document" />
		</cs:namespace>
	</xsl:template>

	<xsl:template match="m:package[@primary='true']" mode="generate-document">
		<xsl:apply-templates mode="generate-document" />
	</xsl:template>

	<xsl:template match="m:entity" mode="generate-document">
		<cs:class name="{@name}" modifiers="partial ">
			<xsl:apply-templates mode="attributes" />
			<xsl:apply-templates mode="members" />
		</cs:class>
	</xsl:template>

	<xsl:template match="*|text()" mode="attributes" />

	<xsl:template match="sql:table" mode="attributes">
		<cs:attribute>
			<cs:type name="Table" namespace="Linq2Db" />
			<cs:parameter><cs:string text="{@name}"/></cs:parameter>
		</cs:attribute>
	</xsl:template>
	
	<!-- class-name -->
	<xsl:template match="*[@name]" mode="type-name">
		<xsl:value-of select="@name"/>
	</xsl:template>
	
	<xsl:template match="*[@clr:name]" mode="type-name">
		<xsl:value-of select="@clr:name"/>
	</xsl:template>
	
	<!-- generate members -->

	<xsl:template match="*|text()" mode="members" />

	<xsl:template match="m:primaryKey | m:property | m:thisKey | clr:association" mode="members">
		<t:trace msg="{name()} {@name}"/>
		<xsl:apply-templates select="." mode="property"/>
	</xsl:template>
	
	<!-- hasA and hasMany doesn't generate members itself, they delegate this work to inner members -->
	<xsl:template match="m:hasA | m:hasMany" mode="members">
		<t:trace msg="{name()} {@name}" />
		<xsl:apply-templates mode="members" />
	</xsl:template>
	
	<xsl:template match="m:hasA/clr:lazy" mode="members">
		<xsl:apply-templates select="." mode="field"/>
	</xsl:template>

	<!-- member-name -->
	<xsl:template match="*|text()|@*" mode="member-name" />

	<xsl:template match="*[@name]" mode="member-name">
		<xsl:value-of select="@name"/>
	</xsl:template>
	<xsl:template match="*[@clr:name]" mode="member-name">
		<xsl:value-of select="@clr:name"/>
	</xsl:template>
	
	<!-- member-type -->
	<xsl:template match="*|text()|@*" mode="member-type" />
	
	<xsl:template match="*[@type]" mode="member-type">
		<xsl:call-template name="getClrType">
			<xsl:with-param name="type" select="@type" />
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template match="*[clr:type]" mode="member-type">
		<xsl:apply-templates select="clr:type" mode="clr-type" />
	</xsl:template>
	
	<!-- member-attributes -->
	<xsl:template match="*|text()" mode="member-attributes"/>
	
	<!-- member-extension -->
	<xsl:template match="*|text()" mode="member-extension"/>
	<xsl:template match="*" mode="member-extension">
		<xsl:apply-templates mode="member-extension-comments"/>
	</xsl:template>
	
	<xsl:template match="m:hasA/* | m:hasMany/*" mode="member-extension">
		<xsl:variable name="comments" select="../m:description | m:description"/>
		<xsl:apply-templates select="$comments[position() = count($comments)]" mode="member-extension-comments"/>
	</xsl:template>
	
	<!-- member-extension-comments -->
	<xsl:template match="*|text()" mode="member-extension-comments"/>
	
	<xsl:template match="m:description" mode="member-extension-comments">
		<cs:comments>
			<xsl:apply-templates mode="comments" />
		</cs:comments>
	</xsl:template>
	

	
	<!-- property -->
	
	<xsl:template match="*" mode="property">
		<cs:property modifiers="public">
			<xsl:attribute name="name"><xsl:apply-templates select="." mode="property-name"/></xsl:attribute>
			<xsl:apply-templates select="." mode="property-type"/>
			<xsl:apply-templates select="." mode="property-attributes"/>
			<xsl:apply-templates select="." mode="property-extension" />
			<xsl:apply-templates select="." mode="property-accessors"/>
		</cs:property>
	</xsl:template>
	
	<!-- property-name -->
	
	<xsl:template match="m:hasA/clr:association[not(@name|@clr:name)]" mode="property-name">
		<!-- if the association doesn't define a name, use it from the parent node -->
		<xsl:apply-templates select=".." mode="property-name"/>
	</xsl:template>
	<xsl:template match="m:hasMany/clr:association[not(@name|@clr:name)]" mode="property-name">
		<!-- if the association doesn't define a name, use it from the parent node -->
		<xsl:apply-templates select=".." mode="property-name"/>
	</xsl:template>
	
	<xsl:template match="*" mode="property-name">
		<xsl:apply-templates select="." mode="member-name"/>
	</xsl:template>
	
	<!-- property-type -->
	<xsl:template match="m:hasA[@type]/clr:association[not(clr:type)]" mode="property-type">
		<xsl:apply-templates select=".." mode="property-type"/>
	</xsl:template>
	
	<xsl:template match="m:hasMany[@type]/clr:association[not(clr:type)]" mode="property-type">
		<cs:array>
			<xsl:apply-templates select=".." mode="property-type"/>
		</cs:array>
	</xsl:template>
	
	<xsl:template match="m:hasA[@type]/m:thisKey" mode="property-type">
		<xsl:call-template name="getKeyType">
			<xsl:with-param name="type" select="../@type"/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template match="m:hasA[@type and boolean(@optional)]/m:thisKey" mode="property-type">
		<cs:nullable>
			<xsl:call-template name="getKeyType">
				<xsl:with-param name="type" select="../@type"/>
			</xsl:call-template>
		</cs:nullable>
	</xsl:template>
	
	<xsl:template match="*" mode="property-type">
		<xsl:apply-templates select="." mode="member-type"/>
	</xsl:template>
	
	<!-- property-attributes -->
	<xsl:template match="m:primaryKey" mode="property-attributes">
		<cs:attribute>
			<cs:type name="PrimaryKey" namespace="Linq2Db" />
		</cs:attribute>
	</xsl:template>
	
	<xsl:template match="m:hasA/clr:association" mode="property-attributes">
		<cs:attribute>
			<cs:type name="Association" namespace="Linq2Db"/>
			<cs:parameter name="thisKey">nameof(<xsl:apply-templates select="../m:thisKey" mode="property-name"/>)</cs:parameter>
			<cs:parameter name="otherKey">nameof(<cs:typeName>
				<xsl:apply-templates select="." mode="property-type"/>
			</cs:typeName>.<xsl:call-template name="getKeyName">
				<xsl:with-param name="type" select="../@type"/>
			</xsl:call-template>)</cs:parameter>
		</cs:attribute>
	</xsl:template>
	
	<xsl:template match="m:hasMany/clr:association" mode="property-attributes">
		<cs:attribute>
			<cs:type name="Association" namespace="Linq2Db"/>
			<!-- thisKey points to own primaryKey which may be inherited, using getKeyName to address such cases -->
			<cs:parameter name="thisKey">nameof(<xsl:call-template name="getKeyName">
					<xsl:with-param name="type" select="../../@name"/>
				</xsl:call-template>)</cs:parameter>
			<cs:parameter name="otherKey">nameof(<cs:typeName>
					<xsl:call-template name="getClrType">
						<xsl:with-param name="type" select="../@type"/>
					</xsl:call-template>
				</cs:typeName>.<xsl:call-template name="getClrPropertyName">
					<xsl:with-param name="member" select="../m:otherKey/@name"/>
					<xsl:with-param name="type" select="../@type"/>
				</xsl:call-template>)</cs:parameter>
		</cs:attribute>
	</xsl:template>
	
	<xsl:template match="*" mode="property-attributes">
		<xsl:apply-templates select="." mode="member-attributes"/>
	</xsl:template>	
	
	<!-- property-extension -->
	<xsl:template match="*" mode="property-extension">
		<xsl:apply-templates select="." mode="member-extension"/>
	</xsl:template>
	
	<!-- property-accessors -->
	<xsl:template match="*" mode="property-accessors">
		<cs:get/>
		<cs:set/>
	</xsl:template>
	
	<xsl:template match="m:hasA[clr:lazy]/m:thisKey" mode="property-accessors">
		<cs:get>
			<xsl:text>return </xsl:text>
			<xsl:apply-templates select="../clr:lazy" mode="field-name"/>
			<xsl:text>.Key;</xsl:text>
		</cs:get>
		<cs:set>
			<xsl:apply-templates select="../clr:lazy" mode="field-name"/>
			<xsl:text>.Key = value;</xsl:text>
		</cs:set>
	</xsl:template>
	
	<xsl:template match="m:hasA[clr:lazy]/clr:association" mode="property-accessors">
		<cs:get>
			<xsl:text>return </xsl:text>
			<xsl:apply-templates select="../clr:lazy" mode="field-name"/>
			<xsl:text>.Instance;</xsl:text>
		</cs:get>
		<cs:set>
			<xsl:apply-templates select="../clr:lazy" mode="field-name"/>
			<xsl:text>.Instance = value;</xsl:text>
		</cs:set>
	</xsl:template>
	
	<!-- fields -->
	<xsl:template match="*" mode="field">
		<cs:field>
			<xsl:attribute name="name"><xsl:apply-templates select="." mode="field-name"/></xsl:attribute>
			<xsl:apply-templates select="." mode="field-type"/>
			<xsl:apply-templates select="." mode="field-initializer"/>
		</cs:field>
	</xsl:template>
	
	<!-- field-name  -->
	<xsl:template match="m:hasA/clr:lazy" mode="field-name">
		<xsl:text>m_lazy</xsl:text>
		<xsl:apply-templates select=".." mode="property-name"/>
	</xsl:template>
	
	<xsl:template match="clr:lazy[@field]" mode="field-name">
		<xsl:value-of select="@field"/>
	</xsl:template>
	
	<xsl:template match="*" mode="field-name">
		<xsl:apply-templates select="." mode="member-name"/>
	</xsl:template>
	
	<!-- field-type -->
	<xsl:template match="m:hasA[@optional='true']/clr:lazy" mode="field-type">
		<cs:type name="NullableReference" namespace="Pallada.Data">
			<xsl:call-template name="getKeyType">
				<xsl:with-param name="type" select="../@type"/>
			</xsl:call-template>
			<xsl:apply-templates select=".." mode="property-type"/>
		</cs:type>
	</xsl:template>
	<xsl:template match="m:hasA[@optional!='true']/clr:lazy" mode="field-type">
		<cs:type name="Reference" namespace="Pallada.Data">
			<xsl:apply-templates select="../m:thisKey" mode="property-type"/>
			<xsl:apply-templates select=".." mode="property-type"/>
		</cs:type>
	</xsl:template>
	
	<xsl:template match="*" mode="field-type">
		<xsl:apply-templates select="." mode="member-type"/>
	</xsl:template>
	<!-- field-initializer -->
	<xsl:template match="*|text()" mode="field-initializer"/>

	<!-- primary key -->
	
	<!-- Resolves primaryKey information for the given type name.
		@returns m:primaryKey node copy with additional attribute
		@declaringType which points to the type where this primaryKey
		was defined.
	-->
	<xsl:template name="getKey">
		<xsl:param name="type" />
		<xsl:for-each select="exsl:node-set($fragment)">
			<xsl:apply-templates select="key('type', $type)"
				mode="resolvePK" />
		</xsl:for-each>
	</xsl:template>
	
	<!--  -->
	<xsl:template name="getKeyType">
		<xsl:param name="type" />
		<xsl:variable name="otherKey">
			<xsl:call-template name="getKey">
				<xsl:with-param name="type" select="$type" />
			</xsl:call-template>
		</xsl:variable>
		<xsl:apply-templates select="exsl:node-set($otherKey)/m:primaryKey" mode="property-type"/>
	</xsl:template>
	
	<xsl:template name="getKeyName">
		<xsl:param name="type" />
		<xsl:variable name="otherKey">
			<xsl:call-template name="getKey">
				<xsl:with-param name="type" select="$type" />
			</xsl:call-template>
		</xsl:variable>
		<xsl:apply-templates select="exsl:node-set($otherKey)/m:primaryKey" mode="property-name"/>
	</xsl:template>

	<!-- internal. applied to the entity with a primaryKey node -->
	<xsl:template match="m:entity[m:primaryKey]" mode="resolvePK">
		<xsl:apply-templates select="m:primaryKey" mode="resolvePK" />
	</xsl:template>

	<!--
	This template formats the result of 'resolvePk' template,
	override this template to extend returned metadata, beware that
	other templates rely on the resulting format of this template.
	-->
	<xsl:template match="m:primaryKey" mode="resolvePK">
		<xsl:copy>
			<xsl:copy-of select="@*" />
			<xsl:attribute name="declaringType"><xsl:value-of select="../@name" /></xsl:attribute>
			<xsl:copy-of select="*" />
		</xsl:copy>
	</xsl:template>

	<!-- internal, used to traverse the hierarchy -->
	<xsl:template match="m:entity" mode="resolvePK">
		<xsl:apply-templates select="m:extends" mode="resolvePK" />
	</xsl:template>

	<!-- internal, used to traverse the hierarchy -->
	<xsl:template match="m:extends" mode="resolvePK">
		<xsl:apply-templates select="key('type', @type)"
			mode="resolvePK" />
	</xsl:template>

	<!-- resolves CLR type for the given type -->
	<xsl:template name="getClrType">
		<xsl:param name="type" />
		<xsl:param name="typeArgs" select="/.." />
		<!-- <t:trace msg="resolveClrType {$type}"/> -->
		<xsl:for-each select="exsl:node-set($fragment)">
			<xsl:apply-templates select="key('type', $type)"
				mode="clr-type">
				<xsl:with-param name="typeArgs" select="$typeArgs"/>
			</xsl:apply-templates>
		</xsl:for-each>
	</xsl:template>
	
	<!-- CLR type construction -->
	<xsl:template match="*" mode="clr-type" />

	<xsl:template match="m:type[clr:type]" mode="clr-type">
		<xsl:param name="typeArgs" select="clr:type/*" />
		<xsl:apply-templates select="clr:type" mode="clr-type">
			<xsl:with-param name="typeArgs" select="$typeArgs" />
		</xsl:apply-templates>
	</xsl:template>

	<xsl:template match="m:entity" mode="clr-type">
		<cs:type name="{@clr:name | @name[not(../@clr:name)]}" namespace="{ancestor::*[@clr:namespace]/@clr:namespace}" />
	</xsl:template>
	
	<xsl:template match="clr:type" mode="clr-type">
		<xsl:apply-templates mode="clr-type"/>
	</xsl:template>

	<xsl:template match="clr:type[@ref]" mode="clr-type">
		<xsl:param name="typeArgs" select="*" />
		<xsl:call-template name="getClrType">
			<xsl:with-param name="type" select="@ref" />
			<xsl:with-param name="typeArgs" select="$typeArgs" />
		</xsl:call-template>
	</xsl:template>

	<xsl:template match="clr:type[@cs:name or @name]" mode="clr-type">
		<xsl:param name="typeArgs" select="*" />
		<xsl:variable name="ns"
			select="@cs:namespace | @namespace[not(../@cs:namespace)]" />
		<cs:type name="{@cs:name | @name[not(../@cs:name)]}">
			<xsl:if test="$ns">
				<xsl:attribute name="namespace"><xsl:value-of select="$ns" /></xsl:attribute>
			</xsl:if>
			<xsl:copy-of select="@struct"/>
			
			<xsl:apply-templates select="$typeArgs | *[not($typeArgs)]"
				mode="clr-type" />
		</cs:type>
	</xsl:template>

	<xsl:template match="clr:arrayOf[@type]" mode="clr-type">
		<xsl:param name="typeArgs" select="*" />
		<cs:array>
			<xsl:call-template name="getClrType">
				<xsl:with-param name="type" select="@type" />
				<xsl:with-param name="typeArgs" select="$typeArgs" />
			</xsl:call-template>
		</cs:array>
	</xsl:template>

	<xsl:template match="clr:arrayOf[@cs:name or @name]" mode="clr-type">
		<xsl:param name="typeArgs" select="*" />
		<xsl:variable name="ns"
			select="@cs:namespace | @namespace[not(../@cs:namespace)]" />
		<cs:array>
			<cs:type name="{@cs:name | @name[not(../@cs:name)]}">
				<xsl:if test="$ns">
					<xsl:attribute name="namespace"><xsl:value-of
						select="$ns" /></xsl:attribute>
				</xsl:if>
				<xsl:apply-templates select="$typeArgs | *[not($typeArgs)]"
					mode="clr-type" />
			</cs:type>
		</cs:array>
	</xsl:template>
	
	<!-- member resolution traits -->
	
	<!-- lookups for the specified member for the specified type
	and returns the CLR property name  -->
	<xsl:template name="getClrPropertyName">
		<xsl:param name="type"/>
		<xsl:param name="member"/>
		<trace msg="getClrPropertyName {$type}.{$member}"/>
		<xsl:for-each select="exsl:node-set($fragment)">
			<xsl:apply-templates select="key('type', $type)"
				mode="member-lookup">
				<xsl:with-param name="member" select="$member"/>
			</xsl:apply-templates>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template match="*" mode="member-lookup"/>
	
	<xsl:template match="m:entity" mode="member-lookup">
		<xsl:param name="member"/>
		<xsl:variable name="match" select="*[@name=$member]"/>
		<xsl:choose>
			<xsl:when test="$match">
				<xsl:apply-templates select="$match" mode="member-lookup"/>
			</xsl:when>
			<xsl:when test="m:extends">
				<xsl:call-template name="getClrPropertyName">
					<xsl:with-param name="type" select="m:extends/@type"/>
					<xsl:with-param name="member" select="$member"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="m:property | m:primaryKey" mode="member-lookup">
		<xsl:apply-templates select="." mode="property-name" />
	</xsl:template>
	
	<xsl:template match="m:hasA" mode="member-lookup">
		<xsl:apply-templates select="m:thisKey" mode="property-name"/>
	</xsl:template>

</xsl:stylesheet>
