<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:m="http://implab.org/schemas/data-model.v1.xsd"
	xmlns:clr="http://implab.org/schemas/data-model/dotnet.v1.xsd"
	xmlns:cs="http://implab.org/schemas/code-dom/csharp.v1.xsd" xmlns:sql="http://implab.org/schemas/data-model/sql.v1.xsd"
	xmlns:t="http://implab.org/schemas/temp" xmlns:exsl="http://exslt.org/common"
	exclude-result-prefixes="clr m xsl exsl sql">
	<xsl:import href="model.xsl"/>
	
	<xsl:template match="m:package[boolean(@primary)]" mode="document">
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			<xsl:apply-templates mode="document"/>
		</xsl:copy>
	</xsl:template>
	<!-- entity -->
	<xsl:template match="m:entity" mode="document">
		<xsl:apply-templates select="." mode="entity"/>
	</xsl:template>
	
	<xsl:template match="m:entity" mode="entity">
		<!-- select all members -->
		<xsl:variable name="members">
			<xsl:apply-templates mode="filter-members"/>
		</xsl:variable>
		
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			
			<xsl:apply-templates select="exsl:node-set($members)" mode="expand-member"/>
		</xsl:copy>	
	</xsl:template>
</xsl:stylesheet>