<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:exsl="http://exslt.org/common">
	<xsl:import href="json.xsl"/>
	<xsl:output method="text" />
	
	<xsl:template match="firstName | lastName" mode="json-member-value">
		<xsl:param name="values" select="."/>
		<xsl:call-template name="write-array">
			<xsl:with-param name="values" select="$values"/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template match="address | work | home" mode="json-object">
		<xsl:call-template name="write-member-string">
			<xsl:with-param name="name" select="'_type'"/>
			<xsl:with-param name="value" select="local-name(.)"/>
		</xsl:call-template>
		
		<xsl:variable name="members" select="@order | *"/>
		<xsl:if test="$members">
			<xsl:call-template name="write-separator"/>
			<xsl:call-template name="write-members">
				<xsl:with-param name="members" select="$members"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="person" mode="json-object">
		<xsl:variable name="address" select="home | work | address"/>
		<xsl:variable name="members" select="*[not(self::home | self::work | self::address)]"/>
		
		<xsl:if test="$address">
			<xsl:call-template name="write-member-array">
				<xsl:with-param name="name" select="'address'"/>
				<xsl:with-param name="values" select="$address"/>
			</xsl:call-template>
		</xsl:if>
		
		<xsl:if test="count($address) > 0 and count($members) > 0">
			<xsl:call-template name="write-separator"/>
		</xsl:if>
		
		<xsl:call-template name="write-members">
			<xsl:with-param name="members" select="$members"/>
		</xsl:call-template>
		
	</xsl:template>
	
	
</xsl:stylesheet>