<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:t="http://implab.org/schemas/temp"
	xmlns:exsl="http://exslt.org/common" extension-element-prefixes="exsl">
	<!-- TEXT ROUTINES -->
	<xsl:template name="writeLine">
		<xsl:param name="level" select="0" />
		<xsl:param name="text" />
		<xsl:call-template name="indent">
			<xsl:with-param name="level" select="$level" />
		</xsl:call-template>
		<xsl:value-of select="$text" />
		<xsl:text>&#xa;</xsl:text>
	</xsl:template>

	<xsl:template name="indent">
		<xsl:param name="level" select="0" />
		<xsl:if test="$level > 0">
			<xsl:text>    </xsl:text>
			<xsl:call-template name="indent">
				<xsl:with-param name="level" select="$level - 1" />
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<xsl:template name="toLowerFirst">
		<xsl:param name="value" />
		<xsl:variable name="smallcase" select="'abcdefghijklmnopqrstuvwxyz'" />
		<xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'" />
		<xsl:variable name="before" select="substring($value,1,1)" />
		<xsl:variable name="after" select="substring($value,2)" />
		<xsl:value-of
			select="concat(translate($before,$uppercase,$smallcase), $after)" />
	</xsl:template>

	<xsl:template name="toLower">
		<xsl:param name="value" />
		<xsl:variable name="smallcase" select="'abcdefghijklmnopqrstuvwxyz'" />
		<xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'" />
		<xsl:value-of select="translate($value,$uppercase,$smallcase)" />
	</xsl:template>

	<xsl:template name="warn">
		<xsl:param name="msg" />
		<xsl:message terminate="no">
			<xsl:apply-templates select="exsl:node-set($msg)"
				mode="trace" />
		</xsl:message>
	</xsl:template>

	<xsl:template name="error">
		<xsl:param name="msg" />
		<xsl:message terminate="no">
			<xsl:apply-templates select="exsl:node-set($msg)"
				mode="trace" />
		</xsl:message>
	</xsl:template>

	<xsl:template match="t:trace" mode="trace">
		<xsl:param name="level" select="0" />
		<xsl:call-template name="writeLine">
			<xsl:with-param name="text" select="@msg" />
			<xsl:with-param name="level" select="$level" />
		</xsl:call-template>
		<xsl:apply-templates mode="trace">
			<xsl:with-param name="level" select="$level + 1" />
		</xsl:apply-templates>
	</xsl:template>
</xsl:stylesheet>