#!/usr/bin/perl
package MyParser;

use IMPL::declare {
	require => {
		XMLReader => 'XML::LibXML::Reader'
	},
	base => [
		'Yours::Parsers::SaxParser' => undef
	]
};


sub ProcessRootNode {
	my ($this,$node) = @_;
	
	my $handler;
	my $level = 1;
	$handler = sub {
		my ($me,$node) = @_;
		print ' ' x $level, $node->depth, " ", $node->name,"\n";
		$level++;
		$me->ReadChildren($handler);
		$level--;
	};
	
	print "root: \n";
	$this->ReadChildren($handler);
}

my $text = '<?xml version="1.0"?>
<root xmlns:ns="asd">
	<n0/>
	<ns:n1 a="hi"></ns:n1>
	<n2>
		<w1>asd</w1>
	</n2>
	<n3 />
</root>
';

my $reader = XMLReader->new({
	string => $text 
});

while ($reader->read) {
	print " " x $reader->depth, "[", $reader->nodeType,"] ", $reader->name, "\n"
}

print "\n";

MyParser->new()->Parse({
	string => $text
});

