#!/usr/bin/perl
use strict;

use IMPL::require {
	Repository => 'Yours::Model::Repository',
	Sync => 'Yours::SyncRepository',
	Dumper => 'Data::Dumper',
	
};

my @repos = (
	{
		name => 'gnome',
		dir => 'gnome',
		location => 'http://download.opensuse.org/repositories/GNOME:/STABLE:/3.8/openSUSE_12.3/'
	},
	{
		name => 'mono',
		dir => 'mono',
		location => 'http://download.opensuse.org/repositories/Mono/openSUSE_12.3/'
	},
	{
		name => 'nvidia',
		dir => 'nvidia',
		location => 'ftp://download.nvidia.com/opensuse/12.3/'
	},
	{
		name => 'broken',
		dir => 'broken',
		location => 'http://mirror.yandex.ru/opensuse/repositories/KDE:/Extra/KDE_Release_410_openSUSE_12.3/'
	}
);

foreach my $info ( @repos ) {
	eval {
		my $repo = Repository->new( map $info->{$_},qw(name dir location));
		Sync
			->new({
				log => *STDOUT,
				skipDebug => 1,
				skipSrc => 1
			}) 
			->Update($repo);
	};
	if(my $err = $@) {
		print eval { $err->message || $err }, "\n";
	} else {
		print "done\n";
	}
}


print "ALL TASKS COMPLETE\n";