#!/usr/bin/perl
package MyParser;

use IMPL::declare {
	base => [
		'Yours::Parsers::SaxParser' => undef
	]
};

sub ProcessRootNode {
	my ($this,$node) = @_;
	
	my $handler;
	my $level = 0;
	$handler = sub {
		my ($me,$node) = @_;
		print ' ' x $level, $node->depth, " ", $node->name,"\n";
		$level++;
		$me->ReadChildren($handler);
		$level--;
	};
	
	print "root: \n";
	$this->ReadChildren($handler);
}

my $text = '<?xml version="1.0"?>
<root>
	<n1></n1>
	<n2>
		<w1>asd</w1>
	</n2>
	<n3></n3>
</root>
';

MyParser->new()->Parse({
	string => $text 
});

