package Yours::FileValidator;
use strict;

use Digest;
use IMPL::declare {
	base => [
		'IMPL::Object' => undef
	]
};

my %digestTypes = (
	sha => 'SHA-1',
	sha512 => 'SHA-512',
	sha384 => 'SHA-384',
	sha256 => 'SHA-256',
	sha1 => 'SHA-1',
	md5 => 'MD5',
	md4 => 'MD4'
);


sub Validate {
	my ($this,$files) = @_;
	
	my @bad;

	while(my ($file,$md) = each %$files) {
		
		unless (-f $file) {
			push @bad, {
				message => "file not found",
				file => $file,
				metadata => $md
			};
			next;
		}
		
		if (my $checksum = $md->{checksum}) {
			
			if( my $type = $digestTypes{lc($checksum->{type})} ) {
				
				if(open my $hfile, "<$file") {
					binmode $hfile;
					my $digest = Digest->new($type)->addfile($hfile)->hexdigest;
					next if $digest eq $checksum->{value};

					push @bad, {
						message => "checksumm failed",
						file => $file,
						metadata => $md
					};
				} else {
					push @bad, {
						message => "unable to open the file",
						file => $file,
						metadata => $md
					}; 
				}
				
			} else {
				$this->Log("$file: unknown hash algorithm: $checksum->{type}");
			}
		}
	}
	
	return @bad;
}

sub Log {
	
}

1;