package Yours::Parsers::MDParser;
use strict;

use IMPL::Const qw(:prop);
use IMPL::declare {
	require => {
		Dumper => 'Data::Dumper'
	},
	base => [ 'Yours::Parsers::SaxParser' => '@_' ],
	props => [
		data => PROP_RW | PROP_DIRECT
	]
};

BEGIN {
	__PACKAGE__->XMLReader->import;
}

sub ProcessRootNode {
	my ( $this, $reader ) = @_;

	my $meta = $this->ReadComplexNode({
		revision => 'ReadTextNode',
		data => [
			sub {
				my $me = shift;
				my $type = $me->attribute('type');
				my $value = $me->ReadComplexNode({
					location => sub { shift->attribute('href')},
					timestamp => 'ReadTextNode',
					checksum => sub {
						my ($me) = @_;
						return {
							type => $me->attribute('type'),
							value => $me->ReadTextNode()
						};
					}
				});
				$value->{type} = $type;
				return $value;
			}
		]
	});
	
	$this->data($meta);
}

1;
