package Yours::Parsers::DIMDParser;
use strict;

use IMPL::Const qw(:prop);
use IMPL::declare {
	base => [
		'Yours::Parsers::SaxParser' => '@_'
	],
	props => [
		onpackage => PROP_RW
	]
};

sub CTOR {
	my ($this,$handler) = @_;
	
	$this->onpackage($handler);
}

sub ProcessRootNode {
	my ($this,$node) = @_;
	
	$this->ReadComplexContent({
		newpackage => 'ProcessPackageRecord'
	});
}

sub ProcessPackageRecord {
	my ($this,$node) = @_;

	my $name = $this->attribute('name');
	my $arch = $this->attribute('arch');
	
	my $deltas = $this->ReadComplexContent({
		delta => [{
			'location:filename' => 'ReadTextNode',
			size => 'ReadTextNode',
			checksumm => sub {
				my $me = shift;
				return {
					type => $me->attribute('type'),
					value => 'ReadTextNode'
				}
			}
		}]
	})->{delta};
	
	if (my $handler = $this->onpackage) {
		foreach my $delta ( @{$deltas || []} ) {
			$delta->{name} = $name;
			$delta->{arch} = $arch;
			$handler->($delta);
		}
	}
	
	return;
}

1;