package Yours::Parsers::PMDParser;
use strict;

use IMPL::Const qw(:prop);
use IMPL::declare {
	base => [
		'Yours::Parsers::SaxParser' => '@_'
	],
	props => [
		onpackage => PROP_RW
	]
};

sub CTOR {
	my ($this,$handler) = @_;
	
	$this->onpackage($handler);
}

sub ProcessRootNode {
	my ($this,$node) = @_;
	
	$this->ReadChildren(sub {
		my ($me,$reader) = @_;
		my $type = $me->attribute('type');
		
		my $package = $me->ReadComplexNode({
			name => 'ReadTextNode',
			location => sub { shift->attribute('href') },
			checksum => sub {
				my ($me) = @_;
				return {
					type => $me->attribute('type'),
					value => $me->ReadTextNode()
				};
			},
			size => sub { shift->attribute('package') }
		});
		
		$package->{type} = $type;
		
		$me->onpackage->($package)
			if $me->onpackage;
	});
}

1;