#!/usr/bin/perl
use strict;



use IMPL::require {
	Repository => 'Yours::Model::Repository',
	Sync => 'Yours::SyncRepository',
	Dumper => 'Data::Dumper',
	
};

my @repos = (
	{
		name => 'update',
		dir => '_data/update',
		location => 'http://mirror.yandex.ru/opensuse/update/12.3/',
	},
	{
		name => 'gnome',
		dir => '_data/gnome',
		location => 'http://download.opensuse.org/repositories/GNOME:/STABLE:/3.8/openSUSE_12.3/'
	},
	{
		name => 'mono',
		dir => '_data/mono',
		location => 'http://download.opensuse.org/repositories/Mono/openSUSE_12.3/'
	},
	{
		name => 'nvidia',
		dir => '_data/nvidia',
		location => 'ftp://download.nvidia.com/opensuse/12.3/'
	},
	{
		name => 'broken',
		dir => '_data/broken',
		location => 'http://mirror.yandex.ru/opensuse/repositories/KDE:/Extra/KDE_Release_410_openSUSE_12.3/'
	}
);

foreach my $info ( @repos ) {
	eval {
		my $repo = Repository->new( map $info->{$_},qw(name dir location));
		Sync
			->new({
				log => *STDOUT,
				skipDebug => 1,
				skipSrc => 1
			}) 
			->Update($repo);
	};
	if($@) {
		warn $@;
	} else {
		print "done\n";
	}
}


print "ALL TASKS COMPLETE\n";