﻿using System.Console;
using BLToolkit.Data;
using BLToolkit.Mapping;
using BLToolkit.Reflection;

namespace Test
{
  public enum Gender
  {
    [MapValue("F")] | Female
    [MapValue("M")] | Male
    [MapValue("U")] | Unknown
    [MapValue("O")] | Other
  }

  [MapField("PersonID", "ID")]
  public class Person
  {
    public mutable PersonID    : int;
    public mutable FirstName   : string;
    public mutable LastName    : string;
    public mutable MiddleName  : string;
    public mutable Gender      : Gender;
  }

  module Program
  {
    Main() : void
    {
      def p = Person();
      p.FirstName = "John";
      p.LastName  = "Pupkin";

      using (db = DbManager())
      {
        def p = db
          .SetSpCommand("Person_SelectByName", db.CreateParameters(p))
          .ExecuteObject() : Person;

        TypeAccessor.WriteConsole(p);
      }

        WriteLine("Press enter to continue...");
        _ = ReadLine();
    }
  }
}