package Benzin::Bugzilla::XmlWriter;

our %Transform = (
	'Benzin::Bugzilla::Bug' => 'WriteBug',
	'Benzin::Bugzilla::BugComment' => 'WriteBugComment',
	'HASH' => 'WriteHash',
	-plain => 'WriteValue',
	-default => 'WriteValue'
);

use IMPL::Const qw(:prop);
use IMPL::declare {
	require => {
		XMLWriter => 'XML::Writer',
		Bug => 'Benzin::Bugzilla::Bug',
		BugComment => 'Benzin::Bugzilla::BugComment'
	},
	base => [
		'IMPL::Transform' => sub { %Transform }
	],
	props => [
		_writer => PROP_RW
	]
};

use fields qw(_writer);

sub CTOR {
	my SELF $this = shift;
	
	$this->_writer(XMLWriter->new(@_));
}

sub WriteBugList {
	my SELF $this = shift;
	my $bugs = shift || [];
	my $writer = $this->_writer;
	
	
	$writer->xmlDecl("UTF-8");
	$writer->startTag("bugzilla");
	
	
	foreach my $bug (@$bugs) {
		$writer->startTag("bug");
		$this->WriteBug($bug);
		$writer->endTag();
	}
	
	$writer->endTag();
	
}

sub WriteBug {
	my SELF $this = shift;
	my $value       = shift;
	my $writer    = $this->_writer;

	foreach my $field ( @{ Bug->BUG_FIELDS } ) {
		next unless $value->{$field};
		$this->WriteElement( $field, $value->{$field} );
	}
}

sub WriteBugComment {
	my SELF $this = shift;
	my $value       = shift;
	my $writer    = $this->_writer;

	foreach my $field ( @{ BugComment->COMMENT_FIELDS } ) {
		next unless $value->{$field};
		$this->WriteElement( $field, $value->{$field} );
	}
}

sub WriteHash {
	my SELF $this = shift;
	my $value = shift;
	
	while(my ($k,$v) = each %$value) {
		$this->WriteElement($k,$v);
	}
}

sub WriteElement {
	my SELF $this = shift;
	my ( $name, $data ) = @_;
	my $writer = $this->_writer;

	my @values =
	     ref($data)
	  && ref($data) eq 'ARRAY'
	  ? @{$data}
	  : $data;

	foreach my $v (@values) {
		$writer->startTag($name);
		$this->Transform( $v );
		$writer->endTag;
	}
}

sub WriteValue {
	my SELF $this = shift;
	my $value = shift;
	
	$this->_writer->characters($value) if defined $value;
}

1;
