package Benzin::Bugzilla::Bug;
use strict;

my @bugFields;

BEGIN {
	@bugFields = qw(
	  id
	  summary
	  creation_time
	  last_change_time
	  creator
	  assigned_to
	  qa_contact
	  cc

	  status
	  resolution

	  priority
	  severity
	  url

	  blocks
	  depends_on
	  

	  component
	  product
	  classification
	  version

	  actual_time
	  estimated_time
	  remaining_time
	  deadline
	  
	  comments
	);
}

use constant {
	BUG_FIELDS => \@bugFields
};

use IMPL::declare {
	base => [
	   'IMPL::Object::Fields' => undef
	]
};

use fields @bugFields;

sub CTOR {
	my SELF $this = shift;
    my $data = shift;
    
    $this->{$_} = $data->{$_} foreach grep exists $data->{$_}, SELF->BUG_FIELDS;
}

sub GetEffort {
	my SELF $this = shift;
	
    return $this->{actual_time} + $this->{remaining_time};
}

1;
