package Benzin::Bugzilla::XmlSerializer;

use IMPL::declare {
	require => {
		XMLWriter => 'XML::Writer'
	},
	base => [
		'IMPL::Object::Fields' => undef
	]
};

use fields qw(_writer);

sub CTOR {
	my SELF $this = shift;
	
	$this->{_writer} = XMLWriter->new(@_);
}

sub WriteBugList {
	my SELF $this = shift;
	my $bugs = shift || [];
	my $writer = $this->{_writer};
	
	
	$writer->xmlDecl("UTF-8");
	$writer->startTag("bugzilla");
	
	$writer->startElement("bugs");
	
	$this->WriteBug($_) foreach @$bugs;
	
	$writer->endTag();
	$writer->endTag();
	
}

sub WriteBug {
	my SELF $this = shift;
	my $bug       = shift;
	my $writer    = $this->{_writer};

	$writer->startTag("bug");
	foreach my $field ( @{ Bug->BUG_FIELDS } ) {
		next unless $bug->{$field};
		$this->WriteElement( $field, $bug->{$field} );
	}
	$writer->endTag();
}

sub WriteElement {
	my SELF $this = shift;
	my ( $name, $data ) = @_;
	my $writer = $this->{_writer};

	my @values =
	     ref($data)
	  && ref($data) eq 'ARRAY'
	  ? @{$data}
	  : $data;

	foreach my $v (@values) {
		$writer->dataElement( $name, $v );
	}
}

1;
