package Benzin::Bugzilla::XmlRpcClient;
use strict;

use LWP::UserAgent;
use XMLRPC::Lite;
use YAML::XS qw(Dump);

use IMPL::require {
	Bug => 'Benzin::Bugzilla::Bug'
};

use fields qw(url apikey);

use constant { SELF => __PACKAGE__ };

sub new {
	my $class = shift;
	$class = ref $class || $class;

	my $inst = fields::new($class);
	$inst->CTOR(@_);

	return $inst;
}

sub CTOR {
	my SELF $this = shift;
	my %params = @_;

	$this->{url} = $params{url} or die "An url is required";
	$this->{apikey} = $params{apikey} if $params{apikey};
}

sub GetBugs {
	my SELF $this = shift;

	return [map Bug->new($_), @{$this->_CallService( 'Bug.get', shift )->{bugs} || [] }];
}

sub FillBugComments {
	my SELF $this = shift;
	my $bugs = shift || [];

	if ( my @ids = map $_->{id}, @$bugs ) {

		my $comments = $this->_CallService( 'Bug.comments', { ids => \@ids } );
		
		for my Bug $bug (@$bugs) {
			map   @{$comments->{$bug->{id}}->{comments} || [] };
		}
	}
}

sub _CallService {
	my SELF $this = shift;
	my ( $method, $params ) = @_;

	die "Method must be specified" unless $method;
	$params ||= {};

	$params->{api_key} = $this->{apikey};
	my $url = URI->new_abs( 'xmlrpc.cgi', $this->{url} );

	my $result = XMLRPC::Lite->proxy($url)->call( $method, $params );

	die $result->fault if $result->fault;
	return $result->result;
}

1;
