package Benzin::Bugzilla::XmlRpcClient;
use strict;

use YAML::XS qw(Dump);
use URI;

use IMPL::declare {
	require => {
		Bug          => 'Benzin::Bugzilla::Bug',
		BugComment   => 'Benzin::Bugzilla::BugComment',
		Deserializer => 'Benzin::Bugzilla::XmlRpcDeserializer',
		XmlRpc       => 'XMLRPC::Lite'
	},
	base => { 'IMPL::Object::Fields' => undef }
};

use fields qw(url apikey _client);

sub CTOR {
	my SELF $this = shift;
	my %params = @_;

	$this->{url} = $params{url} or die "An url is required";
	$this->{apikey} = $params{apikey} if $params{apikey};
	
	#create slightly modified client to parse datetime values
	my $url = URI->new_abs( 'xmlrpc.cgi', $this->{url} );
	
	$this->{_client} =
	  XmlRpc->new( deserializer => Deserializer->new() )->proxy($url);

}

sub GetBugs {
	my SELF $this = shift;

	return [
		map Bug->new($_),
		@{ $this->_CallService( 'Bug.get', shift )->{bugs} || [] }
	];
}

sub GetBugsHierarchy {
	my SELF $this = shift;
	my $args = shift || {};
	
	my @queue = @{$args->{ids}};
	my %visited;
	
	my @fetched;

	while (@queue) {
		@queue = grep not( $visited{$_}++ ), @queue;

		last unless @queue;

		my $bugs = $this->GetBugs( { ids => \@queue } );
		@queue = ();

		foreach my Bug $bug (@$bugs) {

			push @queue, @{ $bug->{depends_on} }
			  if ( $bug->{depends_on} );
			push @fetched, $bug;
		}
	}
	
	return \@fetched;
}

sub PopulateBugsComments {
	my SELF $this = shift;
	my $bugs = shift || [];

	if ( my @ids = map $_->{id}, @$bugs ) {

		my $resp = $this->_CallService( 'Bug.comments', { ids => \@ids } );

		for my Bug $bug (@$bugs) {
			$bug->{comments} = [
				map BugComment->new($_),
				@{ $resp->{bugs}{ $bug->{id} }->{comments} || [] }
			];
		}
	}
	return;
}

sub PopulateBugsHistory {
	my SELF $this = shift;

	my %bugs = map { $_->{id}, $_ } @{ shift || [] };

	if ( keys %bugs ) {

		my $resp =
		  $this->_CallService( 'Bug.history', { ids => [ keys %bugs ] } )
		  ->{bugs};

		for my $data (@$resp) {
			my Bug $bug = $bugs{ $data->{id} };

			$bug->{history} = $data->{history};
		}
	}
	return;
}

sub _CallService {
	my SELF $this = shift;
	my ( $method, $params ) = @_;

	die "Method must be specified" unless $method;
	$params ||= {};

	$params->{api_key} = $this->{apikey};
	

	my $result = $this->{_client}->call( $method, $params );

	die $result->fault if $result->fault;
	return $result->result;
}

1;
