package Benzin::Bugzilla::Bug;
use strict;
use POSIX;
use Scalar::Util qw(looks_like_number);
use DateTime;

my @fields;

BEGIN {
	@fields = qw(
	  id
	  summary
	  creation_time
	  last_change_time
	  creator
	  assigned_to
	  qa_contact
	  cc

	  is_open
	  status
	  resolution

	  priority
	  severity
	  url

	  blocks
	  depends_on

	  component
	  product
	  classification
	  version

	  actual_time
	  estimated_time
	  remaining_time
	  deadline

	  comments
	  history
	);
}

use constant { BUG_FIELDS => \@fields };

use IMPL::lang qw(coarsen coarsen_dt);
use IMPL::declare { base => [ 'IMPL::Object::Fields' => undef ] };
use fields @fields;

sub CTOR {
	my SELF $this = shift;
	my $data = shift;
	$this->{$_} = $data->{$_}
	  foreach grep exists $data->{$_}, @{ SELF->BUG_FIELDS };
}

# returns {
#	reports => [
#		{ who => email:string, start => work-start-date-time:DateTime, end => report-date-time:DateTime, work_time => hours:double }
#	],
#   actual => hours
#	remaining => hours
# }
sub GetTimeReports {
	my SELF $this = shift;
	my $resolution =
	  DateTime::Duration->new( %{ shift() || { minutes => 15 } } );

	my @bookings;
	my $actual = 0;

	for my $history ( @{ $this->{history} || [] } ) {
		my $who     = $history->{who};
		my $when    = coarsen_dt( $history->{when}, $resolution );
		my $changes = $history->{changes};

		for my $change ( @{ $changes || [] } ) {
			if ( $change->{field_name} eq 'work_time' ) {
				my $prev  = $change->{removed} || 0;
				my $value = $change->{added}   || 0;
				if ( looks_like_number($prev) and looks_like_number($value) ) {
					my $dt =
					  coarsen( $value - $prev, $resolution->in_units('hours') );

					if ($dt) {
						push @bookings,
						  {
							who       => $who,
							when      => $when,
							work_time => $dt
						  };
						$actual += $dt;
					}
				}
			}
		}
	}

	my $remaining = coarsen( $this->{remaining_time}, $resolution->in_units('hours') );
	return {
		report    => \@bookings,
		actual    => $actual,
		remaining => $remaining,
		estimated => $actual + $remaining
	};
}

1;
