package Benzin::Bugzilla::XmlRpcDeserializer;
use strict;
use mro;
use parent qw(-norequire XMLRPC::Deserializer);
use IMPL::require { Strptime => 'DateTime::Format::Strptime' };

my $xmlRpcDateFormat = Strptime->new(
	pattern   => '%Y%m%dT%H:%M:%S',
	time_zone => 'UTC',
	on_error  => 'croak'
);

sub decode_value {
	my $this = shift;
	my ( $name, $attrs, $children, $value ) = @{ $_[0] };

	if ( $name eq 'dateTime.iso8601' ) {
		return $xmlRpcDateFormat->parse_datetime($value);
	}
	else {
		$this->next::method(@_);
	}

}

1;

__END__

=pod

=head1 NAME

C<Benzin::Bugzilla::XmlRpcDeserializer> - data deserializer for L<XMLRPC::Lite>.

=head1 SYNOPSIS

=begin code perl

# override the default deserializer
my $client = XMLRPC::Lite->new(
	deserializer => Benzin::Bugzilla::XmlRpcDeserializer->new()
);

=end code perl

=head1 DESCRIPTION

Slightly tuned C<XMLRPC::Deserializer> to parse C<dateTime.iso8601> values to L<DateTime> objects.

=cut
