/*
 ******************************************************************************
 File:     main.c
 Info:     Generated by Atollic TrueSTUDIO(R) 7.0.1   2017-01-12

 The MIT License (MIT)
 Copyright (c) 2009-2016 Atollic AB

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
 ******************************************************************************
 */

/* Includes */
#include "stm32l4xx.h"
#include "gpio.h"

/* Private macro */
/* Private variables */
/* Private function prototypes */
/* Private functions */

/**
 **===========================================================================
 **
 **  Abstract: main program
 **
 **===========================================================================
 */

using namespace halpp;

template<typename TDev, unsigned short PIN> class TLed {
	TDev& m_dev;
public:
	TLed(TDev& dev) :
			m_dev(dev) {

	}

	void Init() const {
		m_dev.SetPinMode(5, halpp::GpioModeOutput);
		m_dev.SetPinOutputType(5, halpp::GpioOutputType::GpioPushPull);
		m_dev.SetPinPullMode(5, halpp::GpioPullMode::GpioNoPull);
	}

	void Set() const {
		m_dev.WritePin(PIN, 1);
	}

	void Reset() const {
		m_dev.WritePin(PIN, 0);
	}

	void Toogle() const {
		m_dev.TooglePin(PIN);
	}
};

class AHB2Bus {
public:
	static void Enable(unsigned int flag) {
		RCC->AHB2ENR |= flag;
	}
};

template<typename TBus, unsigned short ENF> class TDevice {
public:
	static void Enable() {
		TBus::Enable(ENF);
	}
};

class GpioA : public TGpio<GPIO_TypeDef>, public TDevice<AHB2Bus, RCC_AHB2ENR_GPIOAEN> {
	static GpioA m_instance;
	typedef TGpio<GPIO_TypeDef> GpioBase;
public:

	GpioA(GPIO_TypeDef& dev) : GpioBase(dev) {

	}

	static GpioA& instance() {
		return m_instance;
	}
};

GpioA GpioA::m_instance(*GPIOA);

int main(void) {

	/**
	 *  IMPORTANT NOTE!
	 *  The symbol VECT_TAB_SRAM needs to be defined when building the project
	 *  if code has been located to RAM and interrupts are used.
	 *  Otherwise the interrupt table located in flash will be used.
	 *  See also the <system_*.c> file and how the SystemInit() function updates
	 *  SCB->VTOR register.
	 *  E.g.  SCB->VTOR = 0x20000000;
	 */

	/* TODO - Add your application code here */

	GpioA::Enable();

	TLed<halpp::TGpio<GPIO_TypeDef>, 5> led1(GpioA::instance());
	led1.Init();

	/* Infinite loop */
	while (1) {
		led1.Toogle();

		for (int i = 0; i < 1000000; i++) {
		}
	}
}
