/*
 ******************************************************************************
 File:     main.c
 Info:     Generated by Atollic TrueSTUDIO(R) 7.0.1   2017-01-12

 The MIT License (MIT)
 Copyright (c) 2009-2016 Atollic AB

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
 ******************************************************************************
 */

/* Includes */
#include "stm32l4xx.h"
#include "gpio.h"

/* Private macro */
/* Private variables */
/* Private function prototypes */
/* Private functions */

/**
 **===========================================================================
 **
 **  Abstract: main program
 **
 **===========================================================================
 */

using namespace halpp;

template<typename TDev, typename TCounter = uint32_t> class TTimerBase {
public:
	typedef TCounter counter_t;

	static void Init() {
		TDev::instance()->EGR = TIM_EGR_UG;
	}

	static void period(counter_t value) {
		TDev::instance()->ARR = value;
	}

	static counter_t period() {
		return (counter_t) TDev::instance()->ARR;
	}

	static void prescaler(counter_t value) {
		TDev::instance()->PSC = value;
	}

	static counter_t prescaler() {
		return TDev::instance()->PSC;
	}

	static uint32_t resolution() {
		return TDev::frequency() / prescaler();
	}
};

template<typename TDev, typename TCounter = uint32_t> class TTimerChannel1 {
public:
	typedef TCounter counter_t;
	static void duty(counter_t value) {
		TDev::instance()->CCR1 = (uint32_t)value;
	}

	static counter_t duty() {
		return (counter_t)TDev::instance()->CCR1;
	}
};

template<typename TDev, unsigned short PIN, typename TTraits = TGpioTraits<TDev> > class TLed {
	TLed();
	explicit TLed(const TLed&);
public:
	static void Init() {
		TTraits::SetPinMode(PIN, GpioModeOutput);
		TTraits::SetPinOutputType(PIN, GpioPushPull);
		TTraits::SetPinPullMode(PIN, GpioNoPull);
	}

	static void Set() {
		TTraits::WritePin(PIN, 1);
	}

	static void Reset() {
		TTraits::WritePin(PIN, 0);
	}

	static void Toogle() {
		TTraits::TooglePin(PIN);
	}
};

class AHB2Bus {
public:
	static void Enable(unsigned int flag) {
		RCC->AHB2ENR |= flag;
	}
};

class APB1Bus {
public:
	static void Enable(unsigned int flag) {
		RCC->APB1ENR1 |= flag;
	}
};

class APB1Bus2 {
	static void Enable(uint32_t flag) {
		RCC->APB1ENR2 |= flag;
	}
};

template<typename TRegs, typename TBus, uint32_t BASE, uint32_t ENF> class TDevice {
public:
	static TRegs* instance() {
		return (TRegs*) BASE;
	}

	static void Enable() {
		TBus::Enable(ENF);
	}

	static uint32_t frequency() {
		return 80000000;
	}
};

class Hardware {
public:
	typedef TDevice<GPIO_TypeDef, GPIOA_BASE, AHB2Bus, RCC_AHB2ENR_GPIOAEN> GpioA;
	typedef TDevice<TIM_TypeDef, TIM3_BASE, APB1Bus, RCC_APB1ENR1_TIM3EN> Tim3;

	typedef TLed<GpioA, 5> GreenLed;
	typedef TLed<GpioA, 6> Led2;
	typedef TPwmOut<GpioA, 7, Tim3, 2> PwmLed3;
};

int main(void) {

	/**
	 *  IMPORTANT NOTE!
	 *  The symbol VECT_TAB_SRAM needs to be defined when building the project
	 *  if code has been located to RAM and interrupts are used.
	 *  Otherwise the interrupt table located in flash will be used.
	 *  See also the <system_*.c> file and how the SystemInit() function updates
	 *  SCB->VTOR register.
	 *  E.g.  SCB->VTOR = 0x20000000;
	 */

	/* TODO - Add your application code here */

	Hardware::GpioA::Enable();
	Hardware::Tim3::Enable();
	Hardware::GreenLed::Init();
	Hardware::Led2::Init();
	Hardware::PwmLed3::Init(1000);

	int ii = 0;
	/* Infinite loop */
	while (1) {
		Hardware::GreenLed::Toogle();
		Hardware::Led2::Toogle();

		Hardware::PwmLed3::SetDutyFactor(ii / 10.f);

		ii = (ii + 1) % 11; // 0 .. 10

		for (int i = 0; i < 1000000; i++) {

		}
	}
}
